/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.git.bitbucket.BitbucketInstallationRepositories;
import com.teamscale.index.repository.git.bitbucket.server.model.BitbucketVersionInformation;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatuses;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightAnnotations;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightReport;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequestDescription;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequests;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.BitBucketServerPullRequestChanges;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerPullRequestDiffs;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerCodeStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerInlinePullRequestComment;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestActivities;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestComments;
import com.teamscale.index.repository.git.bitbucket.server.model.web_hooks.BitbucketServerWebHook;
import com.teamscale.index.repository.git.bitbucket.server.model.web_hooks.BitbucketServerWebHooks;
import org.checkerframework.checker.nullness.qual.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface IBitbucketServerApi
extends IRetrofitApi {
    public static final String REST_API_BASE_PATH = "rest/api/1.0";
    public static final String SERVER_VERSION_API_ENDPOINT = "rest/api/1.0/application-properties";
    public static final String INSIGHTS_API_BASE_PATH = "rest/insights/1.0";
    public static final String BUILD_STATUS_API_BASE_PATH = "rest/build-status/1.0";
    public static final String LEGACY_COMMIT_STATUS_ENDPOINT = "rest/build-status/1.0/commits/{commit}";
    public static final String PROJECT_KEY_PARAMETER_NAME = "projectKey";
    public static final String REPO_SLUG_PARAMETER_NAME = "repoSlug";
    public static final String PULL_REQUEST_ID_PARAMETER_NAME = "pullRequestId";
    public static final String PAGE_LIMIT_PARAMETER_NAME = "limit";
    public static final String PAGE_START_PARAMETER_NAME = "start";
    public static final String INSIGHT_KEY = "teamscale-report";
    public static final String REPOSITORY_API_ENDPOINT = "rest/api/1.0/projects/{projectKey}/repos/{repoSlug}";
    public static final String INSIGHTS_API_ENDPOINT = "rest/insights/1.0/projects/{projectKey}/repos/{repoSlug}";
    public static final String PULL_REQUEST_API_ENDPOINT = "rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}";
    public static final String TOKEN_CHECK_HEADER = "X-Atlassian-Token: no-check";

    @GET(value="rest/api/1.0/application-properties")
    public BitbucketVersionInformation getServerVersion() throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}")
    public BitbucketInstallationRepositories.InstallationRepository getRepository(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2) throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}")
    public Call<BitbucketServerPullRequest> getPullRequest(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3);

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @PUT(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}")
    public Void putPullRequestDescription(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Body BitbucketServerPullRequestDescription var5) throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests")
    public BitbucketServerPullRequests getOpenPullRequests(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Query(value="limit") int var3, @Query(value="start") @Nullable Long var4, @Query(value="direction") String var5, @Query(value="at") String var6) throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/changes")
    public BitBucketServerPullRequestChanges getPullRequestChanges(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Query(value="limit") int var5, @Query(value="start") @Nullable Long var6) throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/diff")
    public BitbucketServerPullRequestDiffs getPullRequestDiff(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3) throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/comments")
    public BitbucketServerPullRequestComments getPullRequestCommentsForPath(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Query(value="limit") int var5, @Query(value="start") @Nullable Long var6, @Query(value="path") String var7) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @POST(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/comments")
    public Void postInlinePullRequestComment(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Body BitbucketServerInlinePullRequestComment var5) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @POST(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/comments")
    public Void postPullRequestComment(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Body BitbucketServerPullRequestComment var5) throws ServiceCallException;

    @PUT(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/comments/{commentId}")
    public Void putPullRequestComment(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Path(value="commentId") long var5, @Body BitbucketServerPullRequestComment var7) throws ServiceCallException;

    @DELETE(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/comments/{commentId}")
    public Void deletePullRequestComment(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Path(value="commentId") long var5, @Query(value="version") long var7) throws ServiceCallException;

    @PUT(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/participants/{userSlug}")
    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    public Void putPullRequestReviewStatus(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Path(value="userSlug") String var5, @Body BitbucketServerCodeStatus var6) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @POST(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/webhooks")
    public Void postWebHook(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Body BitbucketServerWebHook var3) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @PUT(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/webhooks/{webhookId}")
    public Void putWebHook(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="webhookId") int var3, @Body BitbucketServerWebHook var4) throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/webhooks")
    public BitbucketServerWebHooks getWebhooks(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Query(value="limit") int var3, @Query(value="start") @Nullable Long var4) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @POST(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/commits/{commit}/builds")
    public Void postCommitStatus(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="commit") String var3, @Body CommitStatus var4) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @POST(value="rest/build-status/1.0/commits/{commit}")
    public Void postLegacyCommitStatus(@Path(value="commit") String var1, @Body CommitStatus var2) throws ServiceCallException;

    @GET(value="rest/build-status/1.0/commits/{commit}")
    public CommitStatuses getCommitBuildStatuses(@Path(value="commit") String var1, @Query(value="limit") int var2, @Query(value="start") @Nullable Long var3) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @POST(value="rest/insights/1.0/projects/{projectKey}/repos/{repoSlug}/commits/{commit}/reports/teamscale-report/annotations")
    public Void postCodeInsightAnnotation(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="commit") String var3, @Body BitbucketServerCodeInsightAnnotations var4) throws ServiceCallException;

    @GET(value="rest/insights/1.0/projects/{projectKey}/repos/{repoSlug}/commits/{commit}/reports/teamscale-report")
    public @Nullable BitbucketServerCodeInsightReport getTeamscaleCodeInsightReport(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="commit") String var3) throws ServiceCallException;

    @GET(value="rest/insights/1.0/projects/{projectKey}/repos/{repoSlug}/commits/{commit}/reports/teamscale-report/annotations")
    public @Nullable BitbucketServerCodeInsightAnnotations getTeamscaleCodeInsightReportAnnotations(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="commit") String var3) throws ServiceCallException;

    @Headers(value={"X-Atlassian-Token: no-check", "Content-Type: application/json"})
    @PUT(value="rest/insights/1.0/projects/{projectKey}/repos/{repoSlug}/commits/{commit}/reports/teamscale-report")
    public Void putCodeInsightReport(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="commit") String var3, @Body BitbucketServerCodeInsightReport var4) throws ServiceCallException;

    @DELETE(value="rest/insights/1.0/projects/{projectKey}/repos/{repoSlug}/commits/{commit}/reports/teamscale-report")
    public Void deleteCodeInsightReport(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="commit") String var3) throws ServiceCallException;

    @GET(value="rest/api/1.0/projects/{projectKey}/repos/{repoSlug}/pull-requests/{pullRequestId}/activities")
    public BitbucketServerPullRequestActivities getPullRequestActivities(@Path(value="projectKey") String var1, @Path(value="repoSlug") String var2, @Path(value="pullRequestId") long var3, @Query(value="limit") int var5, @Query(value="start") @Nullable Long var6) throws ServiceCallException;
}

