/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;

public class CcpIntegrationFeatureEnablements {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isAnyIntegrationEnabled(ConnectorConfiguration connector) {
        LOGGER.traceEntry("Checking if any integration is enabled on {}.", new Object[]{connector});
        return CcpIntegrationFeatureEnablements.isFindingsIntegrationEnabled(connector) || CcpIntegrationFeatureEnablements.isTestingIntegrationEnabled(connector) || CcpIntegrationFeatureEnablements.isCommitAlertsIntegrationEnabled(connector);
    }

    public static boolean isAnyBadgeEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isFindingsBadgeEnabled(connector) || CcpIntegrationFeatureEnablements.isTestGapBadgeEnabled(connector);
    }

    public static boolean isAnyBadgeAsMergeRequestCommentEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isAnyBadgeEnabled(connector) && CcpIntegrationFeatureEnablements.isAddingBadgeAsMergeRequestCommentEnabled(connector);
    }

    private static boolean isAddingBadgeAsMergeRequestCommentEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Add badges in a pull request comment", false, connector);
    }

    public static boolean isFindingsIntegrationEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Findings integration for merge requests", true, connector);
    }

    public static boolean isFindingsBadgeEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isFindingsIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Findings Badges", true, connector);
    }

    public static boolean isVotingForFindingsEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isFindingsIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Voting for Findings", true, connector);
    }

    public static boolean isAnyVotingEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isVotingForFindingsEnabled(connector) || CcpIntegrationFeatureEnablements.isVotingForTestGapsEnabled(connector) || CcpIntegrationFeatureEnablements.isVotingForTestCoverageEnabled(connector);
    }

    public static boolean isDetailedLineCommentsForFindingsEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isFindingsIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Detailed Line Comments for Findings", true, connector);
    }

    public static boolean isTestingIntegrationEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Testing integration for merge requests", true, connector);
    }

    public static boolean isTestGapIntegrationEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isTestingIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Test Gap integration for merge requests", true, connector);
    }

    public static boolean isTestGapBadgeEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Test Gap Badges", true, connector);
    }

    public static boolean isTestGapLineCommentsEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Add Detailed Line Comments for Test Gaps", false, connector);
    }

    public static boolean isTestGapSummaryCommentEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Add Test Gaps Summary in a Single Comment", false, connector);
    }

    public static boolean isAnyTestGapCommentOptionEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isTestGapLineCommentsEnabled(connector) || CcpIntegrationFeatureEnablements.isTestGapSummaryCommentEnabled(connector);
    }

    public static boolean isVotingForTestGapsEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Voting for Test Gaps", false, connector);
    }

    public static boolean isVotingForTestCoverageEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isTestingIntegrationEnabled(connector) && CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Voting for Test Coverage", false, connector);
    }

    public static boolean isAnyMetricBadgeEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isMetricThresholdBadgeEnabledInConnectorOption(connector, "Badges for Metrics") || CcpIntegrationFeatureEnablements.isMetricThresholdBadgeEnabledInConnectorOption(connector, "Badges for Metric Groups");
    }

    private static boolean isMetricThresholdBadgeEnabledInConnectorOption(ConnectorConfiguration connector, String metricBadgeConnectorOption) {
        try {
            return VotingConnectorUtils.getMetricBadgesConfiguration(connector, metricBadgeConnectorOption).isEnabled();
        }
        catch (JsonSerializationException e) {
            return false;
        }
    }

    public static boolean isCommitAlertsIntegrationEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Enable Commit Alerts for merge requests", true, connector);
    }

    public static boolean isCommentAggregationEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Aggregate Findings in Single Comment", true, connector);
    }

    public static boolean isIgnoreYellowFindingsForVotesEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Ignore Yellow Findings For Votes", false, connector);
    }

    public static boolean isIgnoreYellowFindingsForCommentsEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Ignore Yellow Findings For Comments", false, connector);
    }

    public static boolean isVotingReviewEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Enable pull request review", false, connector);
    }

    public static boolean isIgnoreYellowTestGapsForVotingEnabled(ConnectorConfiguration connector) {
        return CcpIntegrationFeatureEnablements.isOptionEnabled("Ignore yellow Test Gaps for voting", false, connector);
    }

    public static boolean isOptionEnabled(String optionName, boolean defaultValue, ConnectorConfiguration connector) {
        String optionValue = connector.getOptionValue(optionName);
        if (optionValue == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(optionValue);
    }
}

