/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.resource.TokenElementIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;

public class ExternalUploadsVotingCondition {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @Nullable Long latestCodeTimestamp;
    private final ExternalResultsPartitionLastUpdateIndex lastUpdateIndex;
    private @Nullable Boolean areExternalUploadsReady;

    public ExternalUploadsVotingCondition(ProjectStorageSystem projectStorage, CommitDescriptor schedulingCommit) throws StorageException {
        this.lastUpdateIndex = (ExternalResultsPartitionLastUpdateIndex)projectStorage.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, HistoryAccessOption.readTimestamp((String)schedulingCommit.getBranchName(), (long)schedulingCommit.getTimestamp()));
        IBranchCommitInfo newestCodeCommit = projectStorage.openBranchingLayer("content", TokenElementIndex.class).getNewestCommitBeforeOrAt(schedulingCommit.getBranchName(), schedulingCommit.getTimestamp());
        this.latestCodeTimestamp = newestCodeCommit == null ? null : Long.valueOf(newestCodeCommit.getTimestamp());
    }

    public boolean isFulfilledFor(ConnectorConfiguration connectorConfiguration) throws StorageException {
        if (this.areExternalUploadsReady == null) {
            this.areExternalUploadsReady = this.computeAreExternalUploadsReady(connectorConfiguration);
        }
        return this.areExternalUploadsReady;
    }

    private boolean computeAreExternalUploadsReady(ConnectorConfiguration connector) throws StorageException {
        LOGGER.traceEntry("Checking if external uploads are ready from '{}'.", new Supplier[]{() -> new Throwable().getStackTrace()[1]});
        String partitionsValue = connector.getOptionValue("Partitions Required for Voting");
        List<String> partitions = Arrays.stream(StringUtils.emptyIfNull((String)partitionsValue).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (partitions.isEmpty()) {
            return (Boolean)LOGGER.traceExit("Found no relevant partitions.", (Object)true);
        }
        if (this.latestCodeTimestamp == null) {
            return (Boolean)LOGGER.traceExit("Found no relevant code.", (Object)true);
        }
        List<CommitDescriptor> lastUpdate = this.lastUpdateIndex.getLastUpdatedCommits(partitions);
        List<String> missingPartitions = ExternalUploadsVotingCondition.collectMissingPartitions(lastUpdate, this.latestCodeTimestamp, partitions);
        if (!missingPartitions.isEmpty()) {
            LOGGER.info("Still need to wait on following partitions before voting: " + missingPartitions.stream().sorted().collect(Collectors.joining(", ")));
            return (Boolean)LOGGER.traceExit("Waiting for partitions.", (Object)false);
        }
        return (Boolean)LOGGER.traceExit("All relevant partitions were updated after the code.", (Object)true);
    }

    private static List<String> collectMissingPartitions(List<CommitDescriptor> lastPartitionUpdates, Long latestCodeTimestamp, List<String> partitions) {
        ArrayList<String> missingPartitions = new ArrayList<String>();
        for (int i = 0; i < lastPartitionUpdates.size(); ++i) {
            CommitDescriptor partitionUpdate = lastPartitionUpdates.get(i);
            if (partitionUpdate != null && partitionUpdate.getTimestamp() >= latestCodeTimestamp) continue;
            missingPartitions.add(partitions.get(i));
        }
        return missingPartitions;
    }
}

