/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.replay;

import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.GitCredentials;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnectorParameterStep;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.debug_dump.dump.EGitRepositoryDumpState;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDump;
import com.teamscale.index.repository.git.debug_dump.replay.GitMainRepositoryMock;
import com.teamscale.index.repository.git.debug_dump.replay.GitRepositoryDebugDumpReader;
import com.teamscale.index.repository.git.debug_dump.replay.RefMock;
import com.teamscale.index.repository.git.labeling.PathBuildingBranchLabeler;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class GitDebugDumpRepositoryConnection
extends GitRepositoryConnection {
    private final Map<String, CommitGraphNode> nodesByName;
    private final Map<String, String> branchesByCommitName;
    private final IChangeRetrieverCommitTree commitTree;

    public GitDebugDumpRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, GitRepositoryConnectorParameterStep gitParameterStep, Path debugDumpPath, String userName, String password, @Nullable GitPrivateKeyOption privateKeyOption, ICancelable cancelable, boolean keepResurrectedBranchHistory) throws RepositoryException {
        super(connectorBaseParameterStep, gitParameterStep, new GitCredentials(userName, password, debugDumpPath.toUri(), privateKeyOption), cancelable, false, true);
        this.nodesByName = GitRepositoryDebugDumpReader.readCommitGraph(debugDumpPath);
        this.branchesByCommitName = GitRepositoryDebugDumpReader.readBranchesByCommitName(debugDumpPath);
        try {
            GitRepositoryInfoIndex gitInfoIndex = this.gitParameters.getGitInfoIndex();
            gitInfoIndex.persistBranchNamesByCommitName(this.branchesByCommitName);
            gitInfoIndex.storeInitialDefaultBranchRootRevision(GitRepositoryDebugDumpReader.readInitialDefaultBranchRootRevision(debugDumpPath));
        }
        catch (StorageException e) {
            CCSMAssert.fail((String)"Could not persist branch names by commit name", (Throwable)e);
        }
        GitRepositoryDump gitRepositoryDump = GitRepositoryDebugDumpReader.readGitRepositoryDump(debugDumpPath);
        ((GitMainRepositoryMock)this.repository).setBranches(CollectionUtils.map(gitRepositoryDump.refs, RefMock::new));
        ((GitMainRepositoryMock)this.repository).setCommits(gitRepositoryDump.commits);
        this.commitTree = GitRepositoryDebugDumpReader.readCommitTree(debugDumpPath, EGitRepositoryDumpState.PRE_LABEL);
        this.keepResurrectedBranchHistory = keepResurrectedBranchHistory;
    }

    @Override
    public Map<String, CommitGraphNode> buildCommitGraph(List<? extends ICommitTreeNode> oldNodes) {
        return this.nodesByName;
    }

    @Override
    protected @NonNull PathBuildingBranchLabeler createBranchLabeler(Map<String, String> branchByCommitFromGitInfoIndex, ICommitTree ignored, Map<String, CommitGraphNode> nodesByName) {
        return super.createBranchLabeler(this.branchesByCommitName, (ICommitTree)this.commitTree, nodesByName);
    }

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(IChangeRetrieverCommitTree ignored) throws RepositoryException, RescheduleRequestedException {
        return super.expandCommitTreeNodes(this.commitTree);
    }

    public ICommitTree getCommitTree() {
        return this.commitTree;
    }

    @Override
    public void doSynchronize() {
    }

    @Override
    protected void doSynchronizeAndRescheduleIfNecessary() {
    }

    @Override
    protected void updateBranchPointerIndexFromGitRepository(Map<String, CommitGraphNode> nodesByName) {
    }
}

