/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.fasterxml.jackson.core.type.TypeReference;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.log.interaction.InteractionLogMessage;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.index.repository.git.gerrit.IGerritRestApi;
import com.teamscale.index.repository.git.gerrit.data.ChangeInfo;
import com.teamscale.index.repository.git.gerrit.data.CommentInfo;
import com.teamscale.index.repository.git.gerrit.data.FileInfo;
import com.teamscale.index.repository.git.gerrit.data.ProjectInfo;
import com.teamscale.index.repository.git.gerrit.data.ReviewInput;
import com.teamscale.index.repository.git.gerrit.data.RobotCommentInfo;
import com.teamscale.index.utils.RestClientBase;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.net.UrlUtils;

public class GerritRestClient
extends RestClientBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String JSON_MEDIA_TYPE = "text/json";
    private static final String JSON_BUG_PREFIX = ")]}'\n";
    private final IGerritRestApi gerritRestApi;
    private final IGerritRestApi gerritRestApiWithoutObjectMapper;
    private static final int GERRIT_CHANGE_NOT_FOUND = 404;
    private static final DateTimeFormatter GERRIT_API_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS Z");

    public GerritRestClient(String url, String userName, String password, List<String> cookieStringList, int readTimeoutSeconds, ERestClientAuthenticationMode authenticationMode) {
        super(url, userName, password);
        this.gerritRestApi = this.createGerritRestApi(cookieStringList, readTimeoutSeconds, authenticationMode);
        this.gerritRestApiWithoutObjectMapper = this.createGerritRestApiWithoutObjectMapper(cookieStringList, readTimeoutSeconds, authenticationMode);
    }

    public Collection<ProjectInfo> getProjects() throws ConnectorValidationException {
        Collection<ProjectInfo> collection;
        block9: {
            ResponseBody response = (ResponseBody)Retrofit.executeServiceCall(this.gerritRestApiWithoutObjectMapper.getProjects()).orElseThrow(() -> new ConnectorValidationException("Response is empty."));
            try {
                String responseBodyString = response.string();
                if (!JsonUtils.isValidJson((String)responseBodyString)) {
                    throw new ConnectorValidationException("Could not connect to review API. The following response was returned trying to fetch all projects:\n" + responseBodyString);
                }
                collection = GerritRestClient.deserializeProjects(responseBodyString).values();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ServiceCallException | IOException e) {
                    throw new ConnectorValidationException(e);
                }
            }
            response.close();
        }
        return collection;
    }

    private static Map<String, ProjectInfo> deserializeProjects(String responseBody) throws ConnectorValidationException {
        try {
            return (Map)JsonUtils.deserializeFromJson((String)responseBody, (TypeReference)new TypeReference<Map<String, ProjectInfo>>(){});
        }
        catch (ConQATException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    public List<ChangeInfo> getOpenChanges(String projectId) throws ServiceCallException {
        return GerritRestClient.fetchWithPaging((FunctionWithException<Integer, List<ChangeInfo>, ServiceCallException>)((FunctionWithException)pagingOffset -> this.getOpenChangesWithPaging(projectId, (int)pagingOffset)));
    }

    private List<ChangeInfo> getOpenChangesWithPaging(String projectId, int pagingOffset) throws ServiceCallException {
        return this.gerritRestApi.queryChanges("status:open project:" + projectId, "ALL_REVISIONS", pagingOffset);
    }

    public List<ChangeInfo> getOpenChangesAfter(String projectId, ZonedDateTime date) throws ServiceCallException {
        return GerritRestClient.fetchWithPaging((FunctionWithException<Integer, List<ChangeInfo>, ServiceCallException>)((FunctionWithException)pagingOffset -> this.getOpenChangesAfterWithOffset(projectId, date, (int)pagingOffset)));
    }

    private static List<ChangeInfo> fetchWithPaging(FunctionWithException<Integer, List<ChangeInfo>, ServiceCallException> toFetch) throws ServiceCallException {
        boolean fetchAgain;
        ArrayList<ChangeInfo> results = new ArrayList<ChangeInfo>();
        do {
            results.addAll((Collection)toFetch.apply((Object)results.size()));
        } while (fetchAgain = Optional.ofNullable((ChangeInfo)CollectionUtils.getLast(results)).map(ChangeInfo::isMoreChanges).orElse(false).booleanValue());
        return results;
    }

    public Map<String, FileInfo> getChangedFiles(String changeId, String commitHash) throws ServiceCallException {
        return this.gerritRestApi.getChangedFiles(changeId, commitHash);
    }

    private List<ChangeInfo> getOpenChangesAfterWithOffset(String projectId, ZonedDateTime startDate, int pagingOffset) throws ServiceCallException {
        return this.gerritRestApi.queryChanges("status:open project:" + projectId + " after:\"" + UrlUtils.encodeQueryParameter((String)GERRIT_API_DATE_FORMAT.format(startDate)) + "\"", "CURRENT_REVISION", pagingOffset);
    }

    public List<ChangeInfo> getChangesBetween(String projectId, long startTimestamp, long endTimestamp) throws ServiceCallException {
        ZonedDateTime startDate = DateTimeUtils.atZone((long)startTimestamp);
        ZonedDateTime endDate = DateTimeUtils.atZone((long)endTimestamp);
        return GerritRestClient.fetchWithPaging((FunctionWithException<Integer, List<ChangeInfo>, ServiceCallException>)((FunctionWithException)offset -> this.getChangesBetweenWithOffset(projectId, startDate, endDate, (int)offset)));
    }

    private List<ChangeInfo> getChangesBetweenWithOffset(String projectId, ZonedDateTime startDate, ZonedDateTime endDate, int startNumber) throws ServiceCallException {
        String formattedStartDate = GerritRestClient.encodeDateAsUrl(GERRIT_API_DATE_FORMAT.format(startDate));
        String formattedEndDate = GerritRestClient.encodeDateAsUrl(GERRIT_API_DATE_FORMAT.format(endDate));
        return this.gerritRestApi.queryChanges("project:" + projectId + " after:\"" + formattedStartDate + "\" before:\"" + formattedEndDate + "\"", "ALL_REVISIONS", startNumber);
    }

    private static String encodeDateAsUrl(String date) {
        return date.replace("+", "%2B");
    }

    public void uploadReview(String changeId, String commitHash, ReviewInput reviewInput) throws ServiceCallException {
        try {
            this.gerritRestApi.uploadReview(changeId, commitHash, reviewInput);
            LOGGER.info(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage("Uploaded review: " + reviewInput.getMessage(), this.url, changeId + "/" + commitHash));
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 404) {
                LOGGER.warn(LoggingUtils.INTERACTION, "Could not upload review to Gerrit for commit " + commitHash + ". Probably change " + changeId + " is a draft.\n" + e.getMessage());
                return;
            }
            throw e;
        }
    }

    private IGerritRestApi createGerritRestApi(List<String> cookieStringList, int readTimeoutSeconds, ERestClientAuthenticationMode authenticationMode) {
        return (IGerritRestApi)Retrofit.builder((String)this.url).withInteractionLogger(LOGGER).withAuthenticationMode(authenticationMode, this.username, this.password).withReadTimeout((long)readTimeoutSeconds).withInterceptors(new Interceptor[]{GerritRestClient::jsonBugfixInterceptor}).withCookies(cookieStringList).create(IGerritRestApi.class);
    }

    private static Response jsonBugfixInterceptor(Interceptor.Chain chain) throws IOException {
        try (Response response = chain.proceed(chain.request());){
            String body = Objects.requireNonNull(response.body()).string();
            if (body.startsWith(JSON_BUG_PREFIX)) {
                body = body.substring(JSON_BUG_PREFIX.length());
            }
            Response response2 = response.newBuilder().body(ResponseBody.create((String)body, (MediaType)MediaType.parse((String)JSON_MEDIA_TYPE))).build();
            return response2;
        }
    }

    private IGerritRestApi createGerritRestApiWithoutObjectMapper(List<String> cookieStringList, int readTimeoutSeconds, ERestClientAuthenticationMode authenticationMode) {
        return (IGerritRestApi)Retrofit.builder((String)this.url).withInteractionLogger(LOGGER).withReadTimeout((long)readTimeoutSeconds).withAuthenticationMode(authenticationMode, this.username, this.password).withInterceptors(new Interceptor[]{GerritRestClient::jsonBugfixInterceptor}).withCookies(cookieStringList).withObjectMapper(null).create(IGerritRestApi.class);
    }

    public ChangeInfo getChangeDetails(String changeId) throws ServiceCallException {
        return this.gerritRestApi.getChangeDetail(changeId);
    }

    public Map<String, List<CommentInfo>> getChangeComments(String changeId) throws ServiceCallException {
        return this.gerritRestApi.getChangeComments(changeId);
    }

    public Map<String, List<RobotCommentInfo>> getRobotComments(String changeId) throws ServiceCallException {
        return this.gerritRestApi.getRobotComments(changeId);
    }

    public void deleteReview(String changeId, String reviewLabel) throws ServiceCallException {
        this.gerritRestApi.deleteReview(changeId, reviewLabel);
    }
}

