/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubClientBase;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.client.IGitHubRepositoriesApi;
import com.teamscale.index.repository.git.github.data.GitHubBranch;
import com.teamscale.index.repository.git.github.data.GitHubRepository;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GitHubRepositoriesClient
extends GitHubClientBase<IGitHubRepositoriesApi> {
    public GitHubRepositoriesClient(GitHubApplicationDescription applicationDescription, String accessToken, @Nullable Logger interactionLogger) {
        super(applicationDescription.getApiServer(), accessToken, interactionLogger, IGitHubRepositoriesApi.class);
    }

    public Map<String, Long> getRepositoryLanguages(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return ((IGitHubRepositoriesApi)this.gitHubApi).getRepositoryLanguages(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo());
    }

    public GitHubRepository getRepository(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return ((IGitHubRepositoriesApi)this.gitHubApi).getRepository(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo());
    }

    public List<GitHubBranch> listAllBranches(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubRepositoriesApi)this.gitHubApi).getBranches(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), null, 100), ((IGitHubRepositoriesApi)this.gitHubApi)::getBranchesFromNextPage);
    }
}

