/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.scm_manager.IScmManagerApi;
import com.teamscale.index.repository.git.scm_manager.data.ScmFindingsBadge;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerCiStatus;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerDiff;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequestComments;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequests;
import com.teamscale.index.repository.git.scm_manager.data.ScmTeamscalePluginUrl;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;

public class ScmManagerClient {
    private final String baseUrl;
    private final IScmManagerApi scmManager;

    public ScmManagerClient(@NonNull ExternalCredentials externalCredentials, @Nullable Logger interactionLogger) {
        this(externalCredentials.uri, externalCredentials.username, externalCredentials.password, interactionLogger);
    }

    public ScmManagerClient(String baseUrl, @Nullable String username, String accessTokenOrPassword, @Nullable Logger interactionLogger) {
        this.baseUrl = StringUtils.ensureEndsWith((String)baseUrl, (String)"/");
        this.scmManager = (IScmManagerApi)ScmManagerClient.configureAuthenticationMode(Retrofit.builder((String)this.baseUrl), username, accessTokenOrPassword).withInteractionLogger(interactionLogger).withInterceptors(new Interceptor[]{ScmManagerClient.createErrorMessageInterceptor(this.baseUrl)}).create(IScmManagerApi.class);
    }

    private static Retrofit.Builder configureAuthenticationMode(Retrofit.Builder builder, @Nullable String username, String accessTokenOrPassword) {
        if (StringUtils.isEmpty((String)username)) {
            return builder.withBearerAuthentication(accessTokenOrPassword);
        }
        return builder.withBasicAuthentication(username, accessTokenOrPassword, StandardCharsets.ISO_8859_1);
    }

    private static Interceptor createErrorMessageInterceptor(String baseUrl) {
        return chain -> {
            Response response = chain.proceed(chain.request());
            Optional<String> userFriendlyErrorMessage = ScmManagerClient.createUserFriendlyErrorMessage(response, baseUrl);
            return userFriendlyErrorMessage.map(newMessage -> response.newBuilder().message(response.message() + ". " + newMessage).build()).orElse(response);
        };
    }

    private static Optional<String> createUserFriendlyErrorMessage(Response response, String baseUrl) {
        if (response.code() == 403) {
            return Optional.of("Please make sure that the Teamscale user in the SCM-Manager has the permission role TEAMSCALE.");
        }
        if (response.code() == 404 && response.request().url().encodedPath().contains("/teamscale/") || response.code() == 500) {
            return Optional.of("Please make sure that the Teamscale plugin is installed in the SCM-Manager.");
        }
        if (response.code() == 404 && !baseUrl.endsWith("scm/")) {
            return Optional.of("Please make sure that the base URL in the SCM-Manager account settings is provided including the path context (e.g. '/scm' in the default installation).");
        }
        return Optional.empty();
    }

    public Optional<URI> getRepositoryHttpCloneUri(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return this.scmManager.getRepository(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo()).getCloneUri();
    }

    public ScmManagerPullRequests.PullRequest getPullRequest(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        return this.scmManager.getPullRequest(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId);
    }

    public String getPullRequestUrl(long pullRequestId, String repositoryName) {
        return this.baseUrl + "repo/" + repositoryName + "/pull-request/" + pullRequestId;
    }

    public void putCiStatus(PlatformRepositoryIdentifier repositoryIdentifier, ScmManagerCiStatus.CiStatus status, long pullRequestId) throws ServiceCallException {
        this.scmManager.putCiStatus(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, status.getType(), status.getName(), status);
    }

    public void putTeamscaleInstanceUrl(PlatformRepositoryIdentifier repositoryIdentifier, String teamscaleUrl) throws ServiceCallException {
        this.scmManager.putTeamscaleInstanceUrl(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), new ScmTeamscalePluginUrl(teamscaleUrl));
    }

    public void updateFindingsBadge(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, String badgeAsMarkdown) throws ServiceCallException {
        this.scmManager.putFindingsBadge(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, new ScmFindingsBadge(badgeAsMarkdown));
    }

    public String getFindingsBadeAsMarkdown(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        return this.scmManager.getFindingsBadge(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId).getContent();
    }

    public List<ScmManagerPullRequests.PullRequest> getOpenPullRequests(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return this.scmManager.getOpenPullRequests(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo()).getPullRequests();
    }

    public ScmManagerDiff.Diff getPullRequestDiff(PlatformRepositoryIdentifier repositoryIdentifier, String sourceBranch, String targetBranch) throws ServiceCallException {
        return this.scmManager.getPullRequestDiff(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), sourceBranch, targetBranch);
    }

    public List<ScmManagerPullRequestComments.PullRequestComment> getPullRequestComments(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId) throws ServiceCallException {
        return this.scmManager.getPullRequestComments(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId).getComments();
    }

    public void postPullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, ScmManagerPullRequestComments.PullRequestComment comment) throws ServiceCallException {
        this.scmManager.postPullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, comment);
    }

    public void deletePullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long pullRequestId, String commentId) throws ServiceCallException {
        this.scmManager.deletePullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestId, commentId);
    }
}

