/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.history.match;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryChangeEntry;
import com.teamscale.index.repository.RepositoryChangeIndexBase;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.match.IElementHistoryMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class RepositoryBasedElementHistoryMatcher
implements IElementHistoryMatcher {
    private final ProjectRepositoryChangeIndex changeIndex;
    private final KeyDelta changeDelta;
    private final CommitDescriptor commit;

    public RepositoryBasedElementHistoryMatcher(ProjectRepositoryChangeIndex index, KeyDelta delta, CommitDescriptor commit) {
        this.changeIndex = index;
        this.changeDelta = delta;
        this.commit = commit;
    }

    @Override
    public Map<UniformPath, ElementHistoryEntry> match(Set<RepositoryChangeEntry> addedPaths) throws StorageException {
        List<String> pathAndRevisions = RepositoryChangeIndexBase.getPathAndRevisionsFromKeys(this.changeDelta.getAddedOrChangedKeysAsStrings());
        List<RepositoryChangeEntry> entries = this.changeIndex.getEntries(pathAndRevisions, false);
        HashMap<UniformPath, ElementHistoryEntry> matches = new HashMap<UniformPath, ElementHistoryEntry>();
        for (RepositoryChangeEntry changeEntry : entries) {
            if (changeEntry.getOriginPath() == null || !addedPaths.contains(changeEntry)) continue;
            matches.put(changeEntry.getRepositoryPath(), new ElementHistoryEntry(changeEntry.getOriginPath().toStringAsMigrationFrontier(), Objects.requireNonNull(changeEntry.getOriginCommit()), this.commit, EElementHistoryChangeType.MOVE, changeEntry.getChangeEntryOrigin()));
        }
        return matches;
    }
}

