/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.abap.AbapGitImporter;
import com.teamscale.index.gitbridge.abap.AbapGitImporterUtils;
import com.teamscale.index.gitbridge.abap.UpdateResult;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.index.repository.sap.abapsystem.AbapRepositoryUtil;
import com.teamscale.index.repository.sap.abapsystem.EUpdateMode;
import com.teamscale.index.repository.status.ProjectConnectorStatus;
import com.teamscale.index.sap.AbapTeamscaleSyncIndex;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.LockFailedException;
import org.jetbrains.annotations.VisibleForTesting;

public class AbapRepositoryUpdater {
    private static final String WORKING_DIR = "working";
    private static final String GIT_DIR = "git";
    public static final String ARCHIVE_DIR = "archive";
    static final String FILENAME_FORMAT = "abap_export_%s_%s_%s.zip";
    private final String configurationId;
    private final ServerOptionIndex serverOptionIndex;
    private final AbapTeamscaleSyncIndex abapTeamscaleSyncIndex;
    private final boolean isAllDelta;
    private static final Logger LOGGER = LogManager.getLogger();
    private final String exportHistoryId;
    private final IndexLayer indexLayer;

    public AbapRepositoryUpdater(String configurationId, boolean isAllDelta, ServerOptionIndex serverOptionIndex, GlobalStorageSystem globalStorageSystem, IndexLayer indexLayer) throws StorageException {
        this.configurationId = configurationId;
        this.serverOptionIndex = serverOptionIndex;
        this.isAllDelta = isAllDelta;
        this.exportHistoryId = AbapRepositoryUtil.getOrCreateRepositoryIdentifier((File)this.buildRepositoryLocation(""), configurationId);
        this.abapTeamscaleSyncIndex = (AbapTeamscaleSyncIndex)globalStorageSystem.openGlobalIndex(AbapTeamscaleSyncIndex.class);
        this.indexLayer = indexLayer;
    }

    public UpdateResult updateRepository(BiConsumer<ProjectConnectorStatus.EConnectorStatus, String> repoUpdateStatusReporter) throws StorageException, GitBridgeException {
        UpdateResult lastResult = UpdateResult.nothingUpdated();
        String updateId = this.registerAbapTeamscaleSync();
        LOGGER.debug("SAP System: " + this.configurationId);
        CanonicalFile repositoryLocation = this.buildRepositoryLocation(GIT_DIR);
        LOGGER.debug("Repository location: " + repositoryLocation.getCanonicalPath());
        try (AbapGitImporter abapGitImporter = this.createImporter(repositoryLocation);){
            CanonicalFile workingDir = this.buildRepositoryLocation(WORKING_DIR);
            LOGGER.debug("Working directory: " + workingDir.getCanonicalPath());
            FileSystemUtils.ensureDirectoryExists((File)workingDir);
            for (CanonicalFile zipFile : AbapGitImporterUtils.getSortedExportZips((File)workingDir)) {
                UpdateResult result = abapGitImporter.updateRepository(this.configurationId, zipFile, repoUpdateStatusReporter);
                this.archiveZipFile(zipFile);
                if (result.isAnyCommitPerformed()) {
                    lastResult = result;
                    continue;
                }
                if (!result.getSapVersion().isPresent()) continue;
                lastResult = lastResult.withSapVersion(result.getSapVersion().get());
            }
        }
        catch (JGitInternalException e) {
            this.handleJGitException(repositoryLocation, e);
        }
        catch (IOException e) {
            throw new GitBridgeException(e);
        }
        finally {
            this.updateSapSystemProjects(updateId, lastResult, (File)repositoryLocation);
        }
        return lastResult;
    }

    private void handleJGitException(CanonicalFile repositoryLocation, JGitInternalException e) throws StorageException {
        if (!(e.getCause() instanceof LockFailedException)) {
            throw this.createIdentifiableException("Unexpected internal JGit error when updating Git repository for ABAP sources.", e);
        }
        LOGGER.warn("Can't perform update of ABAP sources for SAP system configuration " + this.configurationId + " since the Git repository at " + String.valueOf(repositoryLocation) + " is currently locked. The most likely reason is a second active instance of Teamscale which is accessing the same Git repository location. You may consider to configure the SAP system connection only in one instance or use separate working directories in the two Teamscale instances.", (Throwable)e);
    }

    @VisibleForTesting
    protected AbapGitImporter createImporter(CanonicalFile repositoryLocation) throws GitBridgeException {
        return new AbapGitImporter(repositoryLocation, "nomail.com", 180, this.isAllDelta);
    }

    public CanonicalFile saveWorkingFile(byte[] zipContent, EUpdateMode updateMode) throws StorageException {
        CanonicalFile zipFile;
        String fileName = AbapRepositoryUtil.createZipFileName(updateMode, this.exportHistoryId, LocalDateTime.now());
        try {
            zipFile = new CanonicalFile((File)this.buildRepositoryLocation(WORKING_DIR), fileName);
            FileSystemUtils.writeFileBinary((File)zipFile, (byte[])zipContent);
        }
        catch (IOException | StorageException e) {
            throw this.createIdentifiableException("Unable to write temporary Zip file " + fileName, e);
        }
        return zipFile;
    }

    private String prependConfigurationId(String message) {
        return this.configurationId + ": " + message;
    }

    private StorageException createIdentifiableException(String message, Throwable cause) {
        return new StorageException(this.prependConfigurationId(message), cause);
    }

    @VisibleForTesting
    protected CanonicalFile buildRepositoryLocation(String subPath) throws StorageException {
        return AbapRepositoryUtil.buildRepositoryLocation(this.configurationId, subPath, this.serverOptionIndex);
    }

    private void archiveZipFile(CanonicalFile zipFile) throws StorageException {
        try {
            AbapGitImporterUtils.archiveAbapZip((File)zipFile, (File)this.buildRepositoryLocation(ARCHIVE_DIR));
        }
        catch (GitBridgeException e) {
            throw this.createIdentifiableException("Unable to archive processed file " + zipFile.getName(), e);
        }
    }

    protected void archiveOldestZip() throws StorageException {
        try {
            Optional oldestZip = AbapGitImporterUtils.getSortedExportZips((File)this.buildRepositoryLocation(WORKING_DIR)).stream().findFirst();
            if (oldestZip.isPresent()) {
                this.archiveZipFile((CanonicalFile)oldestZip.get());
            }
        }
        catch (IOException e) {
            throw new StorageException("Could not archive oldest zip from working directory", (Throwable)e);
        }
    }

    public String getExportHistoryId() {
        return this.exportHistoryId;
    }

    @VisibleForTesting
    protected String registerAbapTeamscaleSync() throws StorageException {
        return this.abapTeamscaleSyncIndex.registerAbapTeamscaleSync(this.configurationId);
    }

    @VisibleForTesting
    protected void updateSapSystemProjects(String syncId, UpdateResult lastResult, File repositoryLocation) throws StorageException {
        if (lastResult.isAnyCommitPerformed()) {
            this.abapTeamscaleSyncIndex.setStateToUpdating(this.configurationId, syncId, lastResult.getCommitTime().get());
            boolean anyProjectUpdated = AbapProjectUtils.updateProjects(this.configurationId, this.indexLayer);
            if (!anyProjectUpdated) {
                AbapProjectUtils.updateProjects(repositoryLocation, this.indexLayer);
            }
        } else {
            this.abapTeamscaleSyncIndex.setStateToCanceled(this.configurationId, syncId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSynchronizations() throws StorageException {
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            Optional<String> syncId = this.abapTeamscaleSyncIndex.getSynchronizationId(this.configurationId);
            if (syncId.isPresent()) {
                this.abapTeamscaleSyncIndex.setStateToCanceled(this.configurationId, syncId.get());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

