/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.tfs.TfsConnection;
import com.teamscale.index.repository.retrievers.ICommitMessagesRetriever;
import com.teamscale.index.repository.tfs.TfsRepositoryUtils;
import java.util.List;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.resource.util.UniformPathUtils;

public class TFSCommitMessagesRetriever
implements ICommitMessagesRetriever {
    @Override
    public List<String> fetchCommitMessages(String branchName, boolean projectExists, String username, ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration) throws RepositoryException {
        String branchUri = UniformPathUtils.concatenate((String[])new String[]{connectorConfiguration.getOptionValue("Path suffix"), branchName});
        try (TfsConnection connection = new TfsConnection(credentials);){
            List<String> list = TfsRepositoryUtils.getLatestChangeSetsWithNonEmptyComment(connection.getVersionControlClient(), branchUri, 10).stream().map(Changeset::getComment).toList();
            return list;
        }
    }
}

