/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.connectors.azure_devops;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.core.tfs.IWorkItemRestClient;
import com.teamscale.core.tfs.wiql.SimpleWiqlBuilder;
import com.teamscale.index.issues.IExternalToolLinkRoleResolver;
import com.teamscale.index.issues.IExternalToolLinkRoleResolverProvider;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.issues.model.ExternalToolLinkRole;
import com.teamscale.index.issues.tfs.AzureDevOpsIssueConnectorUtils;
import com.teamscale.index.issues.tfs.TfsWorkItemFilterParameters;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import com.teamscale.index.requirements_tracing.tools.azure_devops.AzureDevOpsLinkResolver;
import com.teamscale.index.requirements_tracing.triggers.azure_devops.AzureDevOpsSpecItemSynchronizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.TestOnly;

@ConnectorDescriptor
public class AzureDevOpsRequirementsManagementToolConnectorDescriptor
extends RequirementsManagementToolConnectorDescriptorBase
implements IExternalToolLinkRoleResolverProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HttpRequestRetryPolicy httpRequestRetryPolicy;
    private static final String ITEM_TYPE_PARAMETER_NAME = "Item Types";
    @ConfigExposed(name="Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of areas to extract work items from (full area paths). (case-insensitive)")
    private List<String> areas = CollectionUtils.emptyList();
    @ConfigExposed(name="Include Sub-Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-areas are retrieved as well.\nOtherwise, just work items exactly matching one of the area paths are retrieved.")
    private boolean includeSubAreas = false;
    @ConfigExposed(name="Excluded Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of areas to exclude from extracting work items (full area paths). (case-insensitive)")
    private List<String> excludedAreas = CollectionUtils.emptyList();
    @ConfigExposed(name="Exclude Sub-Areas of Excluded Areas", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-areas declared in \"Excluded Areas\" are excluded as well.\nOtherwise, just work items exactly matching one of the area paths are excluded.")
    private boolean excludeSubAreas = false;
    @ConfigExposed(name="Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of iterations to extract work items from (full iteration paths). (case-insensitive)")
    private List<String> iterations = CollectionUtils.emptyList();
    @ConfigExposed(name="Include Sub-Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-iterations are retrieved as well.\nOtherwise, just work items exactly matching one of the iteration paths are retrieved.")
    private boolean includeSubIterations = false;
    @ConfigExposed(name="Excluded Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of iterations to exclude from extracting work items (full iteration paths). (case-insensitive)")
    private List<String> excludedIterations = CollectionUtils.emptyList();
    @ConfigExposed(name="Exclude Sub-Iterations of Excluded Iterations", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, work items from sub-iterations declared in \"Excluded Iterations\" are excluded as well.\nOtherwise, just work items exactly matching one of the iteration paths are excluded.")
    private boolean excludeSubIterations = false;
    @ConfigExposed(name="Tags", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of tags. Import work items with any of these tags only. (case-insensitive)")
    private List<String> tags = CollectionUtils.emptyList();
    @ConfigExposed(name="Excluded Tags", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of tags. Do not import work items with any of these tags. (case-insensitive)")
    private List<String> excludedTags = CollectionUtils.emptyList();
    @ConfigExposed(name="Item Types", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of work item types to retrieve. Leave empty for all item types. Specify type abbreviations after the arrow symbol. (case-insensitive)")
    private PairList<String, String> itemTypes = PairList.fromPairs((Pair)Pair.createPair((Object)"task", (Object)"T"), (Pair[])new Pair[0]);
    @ConfigExposed(name="Closed states", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of states. If a work item is in one of the following states it is considered closed. (case-sensitive)")
    private List<String> closedStates = Arrays.asList("Done", "Closed", "Resolved");
    @ConfigExposed(name="Retrieve history", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="If checked, the full history of a work item is retrieved.\nThis can lead to high load on the TFS-Server.")
    private boolean includeHistory = true;
    @ConfigExposed(name="Included work item link roles", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Comma-separated list of work item link roles to read (e.g. \"Parent\", \"Duplicate\", \"Duplicate Of\").\nThe work item link roles not specified here will be filtered out. (case-sensitive)")
    private List<String> includedWorkItemLinkRoles = new ArrayList<String>();
    private final PairList<String, String> resolvedIncludedWorkItemLinkRoles = new PairList();
    @ConfigExposed(name="Projects", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of projects (or products) in the requirements management tool that work items are extracted from. (case-insensitive)")
    protected List<String> projects = CollectionUtils.emptyList();
    @ConfigExposed(name="Custom Fields", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Comma-separated list of custom fields to be included. This is a pair list of option name and a boolean indicating whether the content of the field should be interpreted as a username.\nExample: 'release-relevant -> false, reviewer -> true'")
    private PairList<String, Boolean> customFields = new PairList();
    @ConfigExposed(name="Item types representing test items", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Comma-separated list of item types (or the abbreviation) that represent test items, which Teamscale should parse and treat as tests. (case-sensitive)")
    private List<String> itemTypesRepresentingTestCases = CollectionUtils.emptyList();
    @ConfigExposed(name="Perform work item cleanup on every Nth poll", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="Determines how often Teamscale should clean up work items that were deleted in Azure DevOps or moved out of the configured Area(s).\nDepending on the number of work items, such a cleanup operation can lead to more load on the Azure DevOps server.\nA value of zero or less indicates that these work items will never be deleted.\nA value of 1 indicates that Teamscale should check for deleted items during every poll.\nA value of 2 indicates every second poll, and so on...\n", changeRequiresReAnalysis=false)
    private int cleanupEveryNthPoll = 1;

    public AzureDevOpsRequirementsManagementToolConnectorDescriptor() {
        this(null, HttpRequestRetryPolicy.SYSTEM_DEFAULT);
    }

    public AzureDevOpsRequirementsManagementToolConnectorDescriptor(AccountCredentials credentials, HttpRequestRetryPolicy httpRequestRetryPolicy) {
        super(ERequirementsManagementTool.AZURE_DEVOPS, credentials);
        this.httpRequestRetryPolicy = httpRequestRetryPolicy;
        this.autoExpose();
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, WorkItemCleanupIndex.buildIndexName(this.connectorIdentifier));
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return AzureDevOpsSpecItemSynchronizer.class;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        this.validateWiqlValues();
        super.validate();
        this.validateAndResolveWorkItemLinks();
    }

    private void validateAndResolveWorkItemLinks() throws ConnectorValidationException {
        if (this.includedWorkItemLinkRoles.size() == this.resolvedIncludedWorkItemLinkRoles.size()) {
            return;
        }
        try {
            Map linkRolesByName = this.getLinkRoleResolverWithoutValidation().loadLinkRoles().stream().collect(Collectors.toMap(ExternalToolLinkRole::getName, Function.identity()));
            for (String includedWorkItemLinkRole : this.includedWorkItemLinkRoles) {
                ExternalToolLinkRole externalToolLinkRole = (ExternalToolLinkRole)linkRolesByName.get(includedWorkItemLinkRole);
                if (externalToolLinkRole == null) {
                    throw new ConnectorValidationException("Unknown Work Item link role: " + includedWorkItemLinkRole);
                }
                this.resolvedIncludedWorkItemLinkRoles.add((Object)includedWorkItemLinkRole, (Object)externalToolLinkRole.getId());
            }
        }
        catch (ServiceCallException e) {
            throw new ConnectorValidationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public IExternalToolLinkRoleResolver getLinkRoleResolver() throws ConnectorValidationException {
        super.validate();
        return this.getLinkRoleResolverWithoutValidation();
    }

    private AzureDevOpsLinkResolver getLinkRoleResolverWithoutValidation() throws ConnectorValidationException {
        ExternalCredentials externalCredentials = this.resolveExternalCredentials();
        return new AzureDevOpsLinkResolver(new TfsHttpConnection(externalCredentials, this.httpRequestRetryPolicy, LOGGER).createWorkItemRestClient());
    }

    private void validateWiqlValues() throws ConnectorValidationException {
        List<String> invalidValues = Stream.concat(Stream.of(this.closedStates, this.projects, this.areas, this.excludedAreas, this.iterations, this.excludedIterations, this.tags, this.excludedTags).flatMap(Collection::stream), this.itemTypes.stream().map(ImmutablePair::getFirst)).filter(Predicate.not(SimpleWiqlBuilder::isValueValidForQuery)).distinct().toList();
        if (!invalidValues.isEmpty()) {
            throw new ConnectorValidationException("The following values may not be used in a query, as they contain ' or \": " + String.valueOf(invalidValues));
        }
        List<String> invalidFieldNames = this.customFields.stream().map(ImmutablePair::getFirst).filter(Predicate.not(SimpleWiqlBuilder::isFieldNameValidForQuery)).distinct().toList();
        if (!invalidFieldNames.isEmpty()) {
            throw new ConnectorValidationException("The following field names may not be used in a query, as they contain one of: ,;'\u00b4:~/\\*|?\"&%$!+=()[]{}<> :" + String.valueOf(invalidValues));
        }
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder specItemSynchronizer) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(specItemSynchronizer);
        this.getFilterParameters().setTriggerParameters(specItemSynchronizer);
        specItemSynchronizer.setTriggerParameter("item-type", ITriggerParameter.of(this.itemTypes));
        specItemSynchronizer.setTriggerParameter("closed-state", ITriggerParameter.of(this.closedStates));
        specItemSynchronizer.setTriggerParameter("include-history", this.includeHistory);
        specItemSynchronizer.setTriggerParameter("project", ITriggerParameter.of(this.projects));
        specItemSynchronizer.setTriggerParameter("item-types-representing-test-cases", ITriggerParameter.of(this.itemTypesRepresentingTestCases));
        this.validateAndResolveWorkItemLinks();
        specItemSynchronizer.setTriggerParameter("included-work-item-link-roles", ITriggerParameter.of(this.resolvedIncludedWorkItemLinkRoles));
        specItemSynchronizer.setTriggerParameter("custom-field", ITriggerParameter.of(this.customFields));
        specItemSynchronizer.setTriggerParameter("cleanupEveryNthPoll", this.cleanupEveryNthPoll);
        specItemSynchronizer.renameIndex("work-item-cleanup-index", WorkItemCleanupIndex.buildIndexName(this.connectorIdentifier));
    }

    private TfsWorkItemFilterParameters getFilterParameters() {
        return new TfsWorkItemFilterParameters(new TfsWorkItemFilterParameters.IncludeExcludeRecursiveFilterParameters(this.areas, this.includeSubAreas, this.excludedAreas, this.excludeSubAreas), new TfsWorkItemFilterParameters.IncludeExcludeRecursiveFilterParameters(this.iterations, this.includeSubIterations, this.excludedIterations, this.excludeSubIterations), new TfsWorkItemFilterParameters.IncludeExcludeFilterParameters(this.tags, this.excludedTags));
    }

    protected void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        IWorkItemRestClient workItemRestClient = new TfsHttpConnection(url, username, password, this.httpRequestRetryPolicy, LOGGER).createWorkItemRestClient();
        AzureDevOpsIssueConnectorUtils.checkWorkItemRetrieval(url, workItemRestClient, this.projects, this.getFilterParameters(), (List<String>)this.itemTypes.getFirstList());
    }

    @TestOnly
    public void setProjectsForTesting(String project) {
        this.projects = new ArrayList<String>();
        this.projects.add(project);
    }
}

