/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.connectors.jira;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.jira.JiraConnectorUtils;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import com.teamscale.index.requirements_tracing.triggers.jira.JiraSpecItemSynchronizer;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

@ConnectorDescriptor
public class JiraRequirementsManagementToolConnectorDescriptor
extends RequirementsManagementToolConnectorDescriptorBase {
    private static final String ISSUE_TYPES_PARAMETER_NAME = "Issue types";
    private static final String ISSUE_TYPES_PARAMETER_DESCRIPTION = "The mapping from the issue types that will be imported from Jira to the type abbreviations used in the UI, e.g.,Requirement -> REQ, Issue -> IS";
    @ConfigExposed(name="Issue types", description="The mapping from the issue types that will be imported from Jira to the type abbreviations used in the UI, e.g.,Requirement -> REQ, Issue -> IS", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private PairList<String, String> issueTypes = PairList.from((Object)"Requirement", (Object)"REQ");
    @ConfigExposed(name="Projects", visibility=ConfigExposed.EConfigVisibility.ADVANCED, description="The projects (or products) in the Jira tracker that specification items are extracted from.\nFor Jira, it is possible to specify the project key or the project name.")
    private List<String> projects = CollectionUtils.emptyList();
    @ConfigExposed(name="Cookies", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="Pattern: (<domain>:)?<name>=<value>\nLines starting with '##' are ignored.", multilineText=true, changeRequiresReAnalysis=false)
    private final List<String> cookies = new ArrayList<String>();

    public JiraRequirementsManagementToolConnectorDescriptor() {
        super(ERequirementsManagementTool.JIRA);
        this.autoExpose();
    }

    public JiraRequirementsManagementToolConnectorDescriptor(AccountCredentials credentials) {
        super(ERequirementsManagementTool.JIRA, credentials);
        this.autoExpose();
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return JiraSpecItemSynchronizer.class;
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("project", ITriggerParameter.of(this.projects));
        issueTrackerTriggerBuilder.setTriggerParameter("cookies", ITriggerParameter.of(this.cookies));
        issueTrackerTriggerBuilder.setTriggerParameter("issue-types-name", ITriggerParameter.of(this.issueTypes));
    }

    protected void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        JiraConnectorUtils.validateAccountDetails(new JiraClient(url, username, password, this.cookies), this.projects);
    }
}

