/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import com.polarion.alm.ws.client.types.projects.Project;
import com.polarion.alm.ws.client.types.tracker.Module;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionServiceClient;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionApplicablePermission;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionDocumentLocation;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class PolarionConnectorValidator {
    public static final String POLARION_DEFAULT_WORK_ITEM_TYPE_ID = "heading";
    private final PolarionDocumentLocation documentLocation;
    private final Set<String> includedWorkItemTypes;
    private final PolarionServiceClient polarionClient;

    public PolarionConnectorValidator(PolarionDocumentLocation documentLocation, Collection<String> includedWorkItemTypes, PolarionServiceClient polarionClient) {
        this.documentLocation = documentLocation;
        this.includedWorkItemTypes = new HashSet<String>(includedWorkItemTypes);
        this.polarionClient = polarionClient;
    }

    public void validateConnector() throws ConnectorValidationException {
        try {
            this.validateProjectId();
            this.validatePermissions();
            this.validateWorkItemTypes();
            ConnectorUtils.validateAndReturnPatterns((String)"Document ID", this.documentLocation.getDocumentNameRegexps());
            this.validateDocumentLocation();
        }
        catch (PolarionServerException | InterruptedException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    private void validateProjectId() throws ConnectorValidationException, PolarionServerException, InterruptedException {
        String projectId = this.documentLocation.getProjectId();
        if (StringUtils.isEmpty((String)projectId)) {
            throw new ConnectorValidationException("The project id is empty.");
        }
        Project project = (Project)this.polarionClient.getProject(projectId).getWithException();
        if (project.isUnresolvable()) {
            throw new ConnectorValidationException("The project with id '%s' could not be found in Polarion server. Project id could be misspelled or the permission to view the project is missing.".formatted(this.documentLocation.getProjectId()));
        }
    }

    private void validateWorkItemTypes() throws InterruptedException, PolarionServerException, ConnectorValidationException {
        String projectId = this.documentLocation.getProjectId();
        List polarionKnownWorkItemTypes = (List)this.polarionClient.getWorkItemTypes(projectId).getWithException();
        Set polarionKnownWorkItemTypeIds = polarionKnownWorkItemTypes.stream().map(PolarionWorkItemType::getId).collect(Collectors.toSet());
        HashSet unknownWorkItemTypes = CollectionUtils.differenceSet(this.includedWorkItemTypes, (Collection[])new Collection[]{polarionKnownWorkItemTypeIds});
        unknownWorkItemTypes.remove(POLARION_DEFAULT_WORK_ITEM_TYPE_ID);
        if (!unknownWorkItemTypes.isEmpty()) {
            throw new ConnectorValidationException("Work item types %s are not defined for project %s in the configured Polarion instance.".formatted(unknownWorkItemTypes, projectId));
        }
    }

    private void validateDocumentLocation() throws PolarionServerException, ConnectorValidationException, InterruptedException {
        Set modules = (Set)this.polarionClient.getModules(this.documentLocation.getProjectId(), this.documentLocation.getLocation()).getWithException();
        if (modules.isEmpty()) {
            throw new ConnectorValidationException("No documents found in the given location: " + this.documentLocation.getLocation());
        }
        boolean anyMatch = false;
        for (String documentNameRegex : this.documentLocation.getDocumentNameRegexps()) {
            Predicate<String> documentNameFilter = Pattern.compile(documentNameRegex).asMatchPredicate();
            if (!modules.stream().map(Module::getId).filter(Objects::nonNull).anyMatch(documentNameFilter)) continue;
            anyMatch = true;
            break;
        }
        if (!anyMatch) {
            String allDocumentIds = modules.stream().map(Module::getId).collect(Collectors.joining(", "));
            throw new ConnectorValidationException("None of the found documents match the provided document names regexps. Are the document name regular expressions correct? Found documents: " + allDocumentIds);
        }
    }

    private void validatePermissions() throws PolarionServerException, ConnectorValidationException, InterruptedException {
        for (EPolarionApplicablePermission applicablePermission : EPolarionApplicablePermission.values()) {
            if (((Boolean)this.polarionClient.hasPermission(this.documentLocation.getProjectId(), applicablePermission.getPermissionId()).getWithException()).booleanValue()) continue;
            throw new ConnectorValidationException("User missing the required permission: " + applicablePermission.getPermissionId() + " for project " + this.documentLocation.getProjectId());
        }
    }
}

