/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer;

import com.polarion.alm.ws.client.types.tracker.CustomFieldType;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemLinkRoleIndex;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemTypeIndex;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionServiceClient;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemType;
import com.teamscale.wia.ExternalToolIssueCustomField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.concurrent.FutureWithException;

public class PolarionFieldsImporter {
    private final PolarionServiceClient polarionClient;
    private final String projectId;

    public PolarionFieldsImporter(String projectId, PolarionServiceClient polarionClient) {
        this.projectId = projectId;
        this.polarionClient = polarionClient;
    }

    public @NonNull TwoDimHashMap<String, String, ExternalToolIssueCustomField> retrieveCustomFieldDefinitions(List<String> includedWorkItemTypeIds) throws InterruptedException, PolarionServerException {
        HashMap<String, FutureWithException<List<CustomFieldType>, PolarionServerException>> futures = new HashMap<String, FutureWithException<List<CustomFieldType>, PolarionServerException>>();
        for (String includedWorkItemType : includedWorkItemTypeIds) {
            futures.put(includedWorkItemType, this.polarionClient.getDefinedCustomFieldTypes(this.projectId, includedWorkItemType));
        }
        try {
            TwoDimHashMap allCustomFields = new TwoDimHashMap();
            for (Map.Entry entry : futures.entrySet()) {
                String includedWorkItemType = (String)entry.getKey();
                List customFieldTypes = (List)((FutureWithException)entry.getValue()).getWithException();
                for (CustomFieldType customField : customFieldTypes) {
                    ExternalToolIssueCustomField externalToolIssueCustomField = new ExternalToolIssueCustomField(customField.getId(), customField.getName(), false, customField.getType().getLocalPart());
                    allCustomFields.putValue((Object)includedWorkItemType, (Object)customField.getId(), (Object)externalToolIssueCustomField);
                }
            }
            return allCustomFields;
        }
        catch (PolarionServerException e) {
            throw new PolarionServerException("Failed to retrieve polarion custom field definitions", e);
        }
    }

    public List<PolarionWorkItemType> retrieveIncludedPolarionWorkItemTypes(PolarionWorkItemTypeIndex polarionWorkItemTypeIndex, PairList<String, String> includedWorkItemTypes) throws PolarionServerException, StorageException, InterruptedException {
        Map includedTypeIdToAbbreviation = includedWorkItemTypes.toMap();
        ArrayList<PolarionWorkItemType> workItemTypes = new ArrayList<PolarionWorkItemType>();
        List<PolarionWorkItemType> availableTypes = polarionWorkItemTypeIndex.getWorkItemTypes(this.projectId);
        if (availableTypes == null) {
            availableTypes = this.retrieveAndStorePolarionWorkItemTypes(polarionWorkItemTypeIndex, true);
        }
        for (PolarionWorkItemType type : availableTypes) {
            if (!includedTypeIdToAbbreviation.containsKey(type.getId())) continue;
            String abbreviation = (String)includedTypeIdToAbbreviation.get(type.getId());
            if (type.getAbbreviation().equals(abbreviation)) {
                workItemTypes.add(type);
                continue;
            }
            PolarionWorkItemType updatedType = new PolarionWorkItemType(type.getId(), type.getName(), (String)includedTypeIdToAbbreviation.get(type.getId()));
            workItemTypes.add(updatedType);
        }
        return workItemTypes;
    }

    public List<PolarionWorkItemLinkRole> retrieveAndStorePolarionWorkItemLinkRoles(PolarionWorkItemLinkRoleIndex index, boolean purge) throws PolarionServerException, StorageException, InterruptedException {
        List<PolarionWorkItemLinkRole> workItemLinkRoles = index.getWorkItemLinkRoles(this.projectId);
        if (!purge && workItemLinkRoles != null) {
            return workItemLinkRoles;
        }
        workItemLinkRoles = new ArrayList<PolarionWorkItemLinkRole>();
        try {
            workItemLinkRoles.addAll((Collection)this.polarionClient.getPolarionWorkItemLinkRoles(this.projectId).getWithException());
        }
        catch (PolarionServerException | InterruptedException e) {
            throw new PolarionServerException("Failed to retrieve polarion work item link roles", e);
        }
        index.setWorkItemLinkRoles(this.projectId, new ArrayList<PolarionWorkItemLinkRole>(workItemLinkRoles));
        return workItemLinkRoles;
    }

    public List<PolarionWorkItemType> retrieveAndStorePolarionWorkItemTypes(PolarionWorkItemTypeIndex index, boolean purge) throws StorageException, PolarionServerException {
        if (!purge) {
            return index.getWorkItemTypes(this.projectId);
        }
        try {
            ArrayList<PolarionWorkItemType> workItemTypes = new ArrayList<PolarionWorkItemType>((Collection)this.polarionClient.getWorkItemTypes(this.projectId).getWithException());
            workItemTypes.add(new PolarionWorkItemType("heading", "Heading", "H"));
            index.storeWorkItemTypes(this.projectId, workItemTypes);
            return workItemTypes;
        }
        catch (PolarionServerException | InterruptedException e) {
            throw new PolarionServerException("Failed to retrieve polarion work item types", e);
        }
    }

    public PolarionServiceClient getPolarionClient() {
        return this.polarionClient;
    }
}

