/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.rtc.model;

import com.teamscale.wia.EDefaultSpecItemLinkRole;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public enum ERtcWorkItemLinkRole {
    PARENT("com.ibm.team.workitem.linktype.parentworkitem", EDefaultSpecItemLinkRole.PARENT, false, false),
    BLOCKS("com.ibm.team.workitem.linktype.blocksworkitem", EDefaultSpecItemLinkRole.DEPENDS_ON, true, false),
    DUPLICATE("com.ibm.team.workitem.linktype.duplicateworkitem", EDefaultSpecItemLinkRole.DUPLICATES, true, false),
    RELATED("com.ibm.team.workitem.linktype.relatedworkitem", EDefaultSpecItemLinkRole.RELATES_TO, false, false),
    COPY("com.ibm.team.workitem.linktype.copiedworkitem", EDefaultSpecItemLinkRole.COPY, false, false),
    RESULT("com.ibm.team.enterprise.promotion.linktype.resultWorkItem", EDefaultSpecItemLinkRole.RESULT, false, false),
    TRACKS("com.ibm.team.workitem.linktype.tracksworkitem", EDefaultSpecItemLinkRole.TRACKS, false, true),
    TRACKED_BY("com.ibm.team.workitem.linktype.trackedworkitem", EDefaultSpecItemLinkRole.TRACKS, true, true),
    AFFECTS("com.ibm.team.workitem.linktype.cm.affectsPlanItem", EDefaultSpecItemLinkRole.AFFECTS, false, true),
    AFFECTED_BY("com.ibm.team.workitem.linktype.cm.affectedByDefect", EDefaultSpecItemLinkRole.AFFECTS, true, true);

    private final String type;
    private final EDefaultSpecItemLinkRole linkRole;
    private final boolean isRoleInverted;
    private final boolean unidirectional;
    private final String readableLinkRole;
    private static final Map<String, ERtcWorkItemLinkRole> TYPE_TO_LINK;
    private static final Map<String, String> READABLE_ROLE_TO_TYPE;

    private ERtcWorkItemLinkRole(String type, EDefaultSpecItemLinkRole linkRole, boolean isRoleInverted, boolean unidirectional) {
        this.type = type;
        this.linkRole = linkRole;
        this.isRoleInverted = isRoleInverted;
        this.unidirectional = unidirectional;
        this.readableLinkRole = this.determineReadableLinkRole();
    }

    private String determineReadableLinkRole() {
        if (!this.unidirectional) {
            return this.linkRole.getMergedLinkRoleName();
        }
        if (this.isRoleInverted) {
            return this.linkRole.getOppositeLinkRoleName();
        }
        return this.linkRole.getLinkRoleName();
    }

    public String getType() {
        return this.type;
    }

    public boolean isUnidirectional() {
        return this.unidirectional;
    }

    public String getLinkRoleName() {
        if (this.isRoleInverted) {
            return this.linkRole.getOppositeLinkRoleName();
        }
        return this.linkRole.getLinkRoleName();
    }

    public String getOppositeLinkRoleName() {
        if (this.isRoleInverted) {
            return this.linkRole.getLinkRoleName();
        }
        return this.linkRole.getOppositeLinkRoleName();
    }

    public String getReadableLinkRole() {
        return this.readableLinkRole;
    }

    public static String getTypeForReadableLinkRole(String linkRole) {
        return READABLE_ROLE_TO_TYPE.get(linkRole);
    }

    public static ERtcWorkItemLinkRole fromType(String type) {
        return TYPE_TO_LINK.get(type);
    }

    static {
        TYPE_TO_LINK = Arrays.stream(ERtcWorkItemLinkRole.values()).collect(Collectors.toMap(ERtcWorkItemLinkRole::getType, Function.identity()));
        READABLE_ROLE_TO_TYPE = Arrays.stream(ERtcWorkItemLinkRole.values()).collect(Collectors.toMap(ERtcWorkItemLinkRole::getReadableLinkRole, ERtcWorkItemLinkRole::getType));
    }
}

