/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.resource.EExtendedResourceType;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.issue_reference.IssueReference;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.scanner.highlighting.SourceCodeStyle;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class FormattedTokenElementInfo
extends TokenElementInfo {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="tokens")
    private final List<Integer> tokens = new ArrayList<Integer>();
    @JsonProperty(value="styles")
    private final List<TokenStyle> styles = new ArrayList<TokenStyle>();
    @JsonIgnore
    private final TwoDimHashMap<Integer, Boolean, Integer> highlightedStyleIndex = new TwoDimHashMap();
    @JsonProperty(value="codeLinks")
    private final Map<Integer, ElementLocation> codeLinks = new HashMap<Integer, ElementLocation>();
    @JsonProperty(value="issueReferencesByCommentOffset")
    private final Map<Integer, List<IssueReference>> issueReferencesByCommentOffset = new HashMap<Integer, List<IssueReference>>();
    @JsonProperty(value="issueReferences")
    private List<IssueReference> issueReferences = new ArrayList<IssueReference>();
    @JsonProperty(value="extendedResourceTypes")
    private Set<EExtendedResourceType> extendedResourceTypes = EnumSet.noneOf(EExtendedResourceType.class);
    @JsonProperty(value="isSupportedByShallowParser")
    private final boolean isSupportedByShallowParser;

    public FormattedTokenElementInfo(TokenElementInfo elementInfo, Set<EExtendedResourceType> extendedResourceTypes) {
        super(elementInfo);
        this.extendedResourceTypes = extendedResourceTypes;
        ELanguage language = elementInfo.getLanguage();
        List scannedTokens = ScannerUtils.getTokens((String)elementInfo.getText(), (ELanguage)language, (String)elementInfo.getUniformPath());
        FormattedTokenElementInfo.insertStyledTokens(language, elementInfo.getText(), scannedTokens, this.tokens, this.styles, (Collection<Deletion>)this.getFilterDeletions());
        this.isSupportedByShallowParser = ShallowParserFactory.getSupportedLanguages().contains(language);
    }

    public void addIssueReferencesIntoFormattedTokens(List<IssueReference> issueReferences) {
        this.issueReferences = issueReferences;
        Map<Integer, Set<OffsetBasedRegion>> regionsByCommentOffset = this.getRegionsByCommentOffset(issueReferences);
        ArrayList<Integer> tokensCopy = new ArrayList<Integer>(this.tokens);
        this.tokens.clear();
        for (int i = 0; i < tokensCopy.size(); i += 3) {
            int startTokenOffset = (Integer)tokensCopy.get(i);
            int endTokenOffset = (Integer)tokensCopy.get(i + 1);
            int styleIndex = (Integer)tokensCopy.get(i + 2);
            if (this.styles.get((int)styleIndex).comment) {
                Set<OffsetBasedRegion> issueReferenceRegions = regionsByCommentOffset.get(startTokenOffset);
                if (issueReferenceRegions == null) {
                    this.addIndicesIntoFormattedTokens(startTokenOffset, endTokenOffset, styleIndex);
                    continue;
                }
                List<OffsetBasedRegion> sortedIssueReferenceRegions = issueReferenceRegions.stream().sorted(Comparator.comparing(SimpleRegion::getStart)).collect(Collectors.toList());
                this.splitFormattedTokensInComments(sortedIssueReferenceRegions, startTokenOffset, endTokenOffset, styleIndex);
                continue;
            }
            this.addIndicesIntoFormattedTokens(startTokenOffset, endTokenOffset, styleIndex);
        }
    }

    private Map<Integer, Set<OffsetBasedRegion>> getRegionsByCommentOffset(List<IssueReference> issueReferences) {
        HashMap<Integer, Set<OffsetBasedRegion>> regionsByCommentOffset = new HashMap<Integer, Set<OffsetBasedRegion>>();
        for (IssueReference issueReference : issueReferences) {
            PairList<Integer, OffsetBasedRegion> commentOffsetsWithRegions = issueReference.getCommentOffsetsWithRegions();
            for (Pair commentOffsetWithRegion : commentOffsetsWithRegions) {
                Integer commentOffset = (Integer)commentOffsetWithRegion.getFirst();
                regionsByCommentOffset.computeIfAbsent(commentOffset, key -> new LinkedHashSet()).add((OffsetBasedRegion)commentOffsetWithRegion.getSecond());
                this.issueReferencesByCommentOffset.computeIfAbsent(commentOffset, key -> new ArrayList()).add(issueReference);
            }
        }
        return regionsByCommentOffset;
    }

    private void splitFormattedTokensInComments(List<OffsetBasedRegion> issueReferenceRegions, int commentStartOffset, int commentEndOffset, int styleIndex) {
        HashMap<TokenStyle, Integer> styleIndexes = new HashMap<TokenStyle, Integer>();
        TokenStyle commentStyle = this.styles.get(styleIndex);
        TokenStyle issueReferenceStyle = new TokenStyle((ImmutablePair<Color, Integer>)new ImmutablePair((Object)commentStyle.color, (Object)1), commentStyle.identifier, true, true);
        int startTokenOffset = commentStartOffset;
        for (OffsetBasedRegion region : issueReferenceRegions) {
            int issueReferenceIdStartOffset = commentStartOffset + region.getStart();
            int issueIdEndOffset = commentStartOffset + region.getEnd();
            this.addIndicesIntoFormattedTokens(startTokenOffset, issueReferenceIdStartOffset - 1, styleIndex);
            Integer issueReferenceStyleIndex = FormattedTokenElementInfo.getOrCreateStyleIndex(this.styles, styleIndexes, issueReferenceStyle);
            this.addIndicesIntoFormattedTokens(issueReferenceIdStartOffset, issueIdEndOffset - 1, issueReferenceStyleIndex);
            startTokenOffset = issueIdEndOffset + 1;
        }
        this.addIndicesIntoFormattedTokens(startTokenOffset, commentEndOffset, styleIndex);
    }

    private void addIndicesIntoFormattedTokens(int startTokenOffset, int endTokenOffset, int styleIndex) {
        this.tokens.add(startTokenOffset);
        this.tokens.add(endTokenOffset);
        this.tokens.add(styleIndex);
    }

    public static void insertStyledTokens(ELanguage language, String textContent, List<IToken> scannerTokens, List<Integer> tokens, List<TokenStyle> styles, Collection<Deletion> filterDeletions) {
        if (language == ELanguage.LINE) {
            FormattedTokenElementInfo.insertStyledTokensForLineLanguage(textContent, tokens, styles, filterDeletions);
            return;
        }
        SourceCodeStyle style = SourceCodeStyle.get((ELanguage)language);
        HashMap<TokenStyle, Integer> styleIndexes = new HashMap<TokenStyle, Integer>();
        for (int i = 0; i < scannerTokens.size(); ++i) {
            IToken token = scannerTokens.get(i);
            IToken previousToken = null;
            if (i > 1) {
                previousToken = scannerTokens.get(i - 1);
            }
            IToken nextToken = null;
            if (i < scannerTokens.size() - 1) {
                nextToken = scannerTokens.get(i + 1);
            }
            ImmutablePair rawStyle = style.getStyle(token, previousToken, nextToken);
            if (Deletion.isFilteredOffset((int)token.getOffset(), filterDeletions)) {
                rawStyle = new ImmutablePair((Object)Color.LIGHT_GRAY, (Object)((Integer)rawStyle.getSecond()));
            }
            TokenStyle tokenStyle = FormattedTokenElementInfo.createTokenStyle(token, (ImmutablePair<Color, Integer>)rawStyle);
            Integer styleIndex = FormattedTokenElementInfo.getOrCreateStyleIndex(styles, styleIndexes, tokenStyle);
            tokens.add(token.getOffset());
            tokens.add(token.getEndOffset());
            tokens.add(styleIndex);
        }
    }

    private static @NonNull Integer getOrCreateStyleIndex(List<TokenStyle> styles, Map<TokenStyle, Integer> styleIndexes, TokenStyle tokenStyle) {
        Integer styleIndex = styleIndexes.get(tokenStyle);
        if (styleIndex == null) {
            styleIndex = styles.size();
            styles.add(tokenStyle);
            styleIndexes.put(tokenStyle, styleIndex);
        }
        return styleIndex;
    }

    private static @NonNull TokenStyle createTokenStyle(IToken token, ImmutablePair<Color, Integer> rawStyle) {
        ETokenType.ETokenClass tokenClass = token.getType().getTokenClass();
        return FormattedTokenElementInfo.createTokenStyle(rawStyle, token.getType() == ETokenType.IDENTIFIER, tokenClass == ETokenType.ETokenClass.DELIMITER, tokenClass == ETokenType.ETokenClass.COMMENT);
    }

    private static @NonNull TokenStyle createTokenStyle(ImmutablePair<Color, Integer> rawStyle, boolean identifier, boolean delimiter, boolean comment) {
        return new TokenStyle(rawStyle, identifier, delimiter, comment);
    }

    private static @NonNull TokenStyle createPlainTextTokenStyle(Color color) {
        return FormattedTokenElementInfo.createTokenStyle((ImmutablePair<Color, Integer>)SourceCodeStyle.style((Color)color), false, false, false);
    }

    private static void insertStyledTokensForLineLanguage(String textContent, List<Integer> tokens, List<TokenStyle> styles, Collection<Deletion> filterDeletions) {
        TokenStyle plainTextStyle = FormattedTokenElementInfo.createPlainTextTokenStyle(Color.BLACK);
        TokenStyle filteredTextStyle = FormattedTokenElementInfo.createPlainTextTokenStyle(Color.LIGHT_GRAY);
        HashMap<TokenStyle, Integer> styleIndexes = new HashMap<TokenStyle, Integer>();
        int currentOffset = 0;
        for (Deletion deletion : filterDeletions) {
            if (deletion.getStartOffset() != 0) {
                tokens.add(currentOffset);
                tokens.add(deletion.getStartOffset() - 1);
                tokens.add(FormattedTokenElementInfo.getOrCreateStyleIndex(styles, styleIndexes, plainTextStyle));
            }
            tokens.add(deletion.getStartOffset());
            tokens.add(deletion.getEndOffset() - 1);
            tokens.add(FormattedTokenElementInfo.getOrCreateStyleIndex(styles, styleIndexes, filteredTextStyle));
            currentOffset = deletion.getEndOffset();
        }
        if (currentOffset < textContent.length()) {
            tokens.add(currentOffset);
            tokens.add(textContent.length() - 1);
            tokens.add(FormattedTokenElementInfo.getOrCreateStyleIndex(styles, styleIndexes, plainTextStyle));
        }
    }

    private int getHighlightedStyleIndex(int styleIndex, boolean broken) {
        Integer result = (Integer)this.highlightedStyleIndex.getValue((Object)styleIndex, (Object)broken);
        if (result == null) {
            result = this.styles.size();
            this.highlightedStyleIndex.putValue((Object)styleIndex, (Object)broken, (Object)result);
            TokenStyle originalStyle = this.styles.get(styleIndex);
            Color color = originalStyle.color;
            if (broken) {
                color = Color.RED;
            }
            this.styles.add(new TokenStyle(color, !originalStyle.bold, originalStyle.italic, true, false, false));
        }
        return result;
    }

    public UnmodifiableList<Integer> getTokenStyleIndices() {
        return CollectionUtils.asUnmodifiable(this.tokens);
    }

    public List<TokenStyle> getStyles() {
        return this.styles;
    }

    public void mapTokenToFile(IToken token, String uniformPath, int line) {
        this.codeLinks.put(token.getOffset(), (ElementLocation)new TextRegionLocation(uniformPath, -1, -1, line, line));
    }

    public void mapTokenToLocation(int rawStartOffset, ElementLocation location) {
        this.codeLinks.put(rawStartOffset, location);
    }

    public <X extends Exception> void mapCommentParts(ICommentPartLinker<X> linker) throws X {
        ArrayList<Integer> tokensCopy = new ArrayList<Integer>(this.tokens);
        this.tokens.clear();
        for (int i = 0; i < tokensCopy.size(); i += 3) {
            int start = (Integer)tokensCopy.get(i);
            int end = (Integer)tokensCopy.get(i + 1);
            int styleIndex = (Integer)tokensCopy.get(i + 2);
            if (this.styles.get((int)styleIndex).comment) {
                this.handleCommentToken(linker, start, end, styleIndex);
                continue;
            }
            this.tokens.add(start);
            this.tokens.add(end);
            this.tokens.add(styleIndex);
        }
    }

    private <X extends Exception> void handleCommentToken(ICommentPartLinker<X> linker, int start, int end, int styleIndex) throws X {
        Optional<CommentPartLink> link;
        String commentText = this.getText().substring(start, end + 1);
        while (start <= end && !(link = linker.extractLink(commentText)).isEmpty()) {
            if (link.get().start > 0) {
                this.tokens.add(start);
                this.tokens.add(start + link.get().start - 1);
                this.tokens.add(styleIndex);
            }
            this.tokens.add(start + link.get().start);
            this.tokens.add(start + link.get().end - 1);
            boolean brokenLink = link.get().linkLocation instanceof QualifiedNameLocation && ((QualifiedNameLocation)link.get().linkLocation).isAbbreviated();
            this.tokens.add(this.getHighlightedStyleIndex(styleIndex, brokenLink));
            this.mapTokenToLocation(start + link.get().start, link.get().linkLocation);
            start += link.get().end;
            commentText = commentText.substring(link.get().end);
        }
        if (start <= end) {
            this.tokens.add(start);
            this.tokens.add(end);
            this.tokens.add(styleIndex);
        }
    }

    @IndexValueClass(containedInBackup=true)
    public static class TokenStyle
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String COLOR_PROPERTY = "color";
        private static final String BACKGROUND_PROPERTY = "background";
        private static final String BOLD_PROPERTY = "bold";
        private static final String ITALIC_PROPERTY = "italic";
        private static final String IDENTIFIER_PROPERTY = "identifier";
        private static final String DELIMITER_PROPERTY = "delimiter";
        @JsonProperty(value="color")
        private final Color color;
        @JsonProperty(value="background")
        private final @Nullable Color background = null;
        @JsonProperty(value="bold")
        private final boolean bold;
        @JsonProperty(value="italic")
        private final boolean italic;
        @JsonProperty(value="identifier")
        private final boolean identifier;
        @JsonProperty(value="delimiter")
        private final boolean delimiter;
        @JsonIgnore
        private final boolean comment;

        public TokenStyle(ImmutablePair<Color, Integer> style, boolean identifier, boolean delimiter, boolean comment) {
            this((Color)style.getFirst(), ((Integer)style.getSecond() & 1) != 0, ((Integer)style.getSecond() & 2) != 0, identifier, delimiter, comment);
        }

        @JsonCreator
        private TokenStyle(@JsonProperty(value="color") String rawColor, @JsonProperty(value="bold") boolean bold, @JsonProperty(value="italic") boolean italic, @JsonProperty(value="identifier") boolean identifier, @JsonProperty(value="delimiter") boolean delimiter) {
            this(ColorUtils.fromString((String)rawColor), bold, italic, identifier, delimiter, false);
        }

        private TokenStyle(Color color, boolean bold, boolean italic, boolean identifier, boolean delimiter, boolean comment) {
            this.color = color;
            this.bold = bold;
            this.italic = italic;
            this.identifier = identifier;
            this.delimiter = delimiter;
            this.comment = comment;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isIdentifier() {
            return this.identifier;
        }

        public int hashCode() {
            return Objects.hash(this.color, this.bold, this.italic, this.identifier, this.delimiter, this.comment);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TokenStyle)) {
                return false;
            }
            TokenStyle other = (TokenStyle)obj;
            return this.bold == other.bold && this.italic == other.italic && this.identifier == other.identifier && Objects.equals(this.color, other.color) && this.delimiter == other.delimiter && this.comment == other.comment;
        }
    }

    public static interface ICommentPartLinker<X extends Exception> {
        public Optional<CommentPartLink> extractLink(String var1) throws X;
    }

    public static class CommentPartLink {
        private final int start;
        private final int end;
        private final ElementLocation linkLocation;

        public CommentPartLink(int start, int end, ElementLocation linkLocation) {
            CCSMAssert.isTrue((start < end ? 1 : 0) != 0, (String)"Start must be less than end!");
            this.start = start;
            this.end = end;
            this.linkLocation = linkLocation;
        }
    }
}

