/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="reparsing-required", options={EStorageOption.COMPRESSED}, valueClasses={String.class})
public class ReparseRequiredIndex
extends IndexBase
implements IRollbackableIndex,
IProjectIndex {
    public static final String INDEX_NAME = "reparsing-required";

    public ReparseRequiredIndex(IStore store) {
        super(store);
    }

    public void storeAdditionalUniformPathsForReparsing(CommitDescriptor commit, Set<String> pathsWithPotentialTokenChange, Set<String> pathsIncludingChangedFiles) throws StorageException {
        byte[] commitRepresentation = commit.toBranchTimestampKeyWithSeparator();
        PairList newEntries = new PairList();
        for (String uniformPath : pathsWithPotentialTokenChange) {
            newEntries.add((Object)ReparseRequiredIndex.buildKey(commitRepresentation, EStorageKeyPrefix.POTENTIAL_TOKEN_CHANGE, uniformPath), (Object)new byte[0]);
        }
        for (String uniformPath : pathsIncludingChangedFiles) {
            newEntries.add((Object)ReparseRequiredIndex.buildKey(commitRepresentation, EStorageKeyPrefix.CHANGED_INCLUDE_TREE, uniformPath), (Object)new byte[0]);
        }
        this.store.put(newEntries);
    }

    private static byte[] buildKey(byte[] commitRepresentation, EStorageKeyPrefix prefix, String uniformPath) {
        byte[] commitRepresentationLength = ByteArrayUtils.intToByteArray((int)commitRepresentation.length);
        return ByteArrayUtils.concat((byte[][])new byte[][]{commitRepresentationLength, commitRepresentation, prefix.byteValue, StringUtils.stringToBytes((String)uniformPath)});
    }

    public List<String> getAdditionalReparsingRequiredPaths(CommitDescriptor commit) throws StorageException {
        byte[] commitRepresentation = commit.toBranchTimestampKeyWithSeparator();
        byte[] commitRepresentationLength = ByteArrayUtils.intToByteArray((int)commitRepresentation.length);
        byte[] keyPrefix = ByteArrayUtils.concat((byte[][])new byte[][]{commitRepresentationLength, commitRepresentation, EStorageKeyPrefix.POTENTIAL_TOKEN_CHANGE.byteValue});
        return this.loadUniformPathsWithKeyPrefix(keyPrefix);
    }

    public List<String> getPathsWithChangeInIncludeTree(CommitDescriptor commit) throws StorageException {
        byte[] commitRepresentation = commit.toBranchTimestampKeyWithSeparator();
        byte[] commitRepresentationLength = ByteArrayUtils.intToByteArray((int)commitRepresentation.length);
        byte[] keyPrefix = ByteArrayUtils.concat((byte[][])new byte[][]{commitRepresentationLength, commitRepresentation, EStorageKeyPrefix.CHANGED_INCLUDE_TREE.byteValue});
        return this.loadUniformPathsWithKeyPrefix(keyPrefix);
    }

    private @NonNull List<String> loadUniformPathsWithKeyPrefix(byte[] keyPrefix) throws StorageException {
        PairList entries = this.store.getEntriesStartingWith(keyPrefix);
        ArrayList<String> uniformPaths = new ArrayList<String>();
        for (byte[] key : entries.extractFirstList()) {
            int pathLength = key.length - keyPrefix.length;
            uniformPaths.add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, keyPrefix.length, keyPrefix.length + pathLength)));
        }
        return uniformPaths;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.isEmpty()) {
            return;
        }
        ArrayList<byte[]> prefixesForRollbackBranches = new ArrayList<byte[]>();
        for (String branchName : timestampByBranch.keySet()) {
            prefixesForRollbackBranches.add(ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)branchName), CommitDescriptor.SEPARATOR}));
        }
        ArrayList allKeysOnRollbackBranches = new ArrayList();
        this.store.scanKeys(prefixesForRollbackBranches, (IKeyValueCallback)new KeyCollectingCallback(allKeysOnRollbackBranches));
        ArrayList<byte[]> invalidKeys = new ArrayList<byte[]>();
        for (byte[] key : allKeysOnRollbackBranches) {
            CommitDescriptor commit = ReparseRequiredIndex.extractCommitFromKey(key);
            Long newestValidTimestampForBranch = timestampByBranch.get(commit.getBranchName());
            if (newestValidTimestampForBranch == null || commit.getTimestamp() <= newestValidTimestampForBranch) continue;
            invalidKeys.add(key);
        }
        this.store.remove(invalidKeys);
    }

    private static CommitDescriptor extractCommitFromKey(byte[] key) {
        int commitDescriptorBytesLength = ByteArrayUtils.readIntFromStartOfArray((byte[])key);
        return CommitDescriptor.fromBranchTimestampKeyWithSeparator((byte[])Arrays.copyOfRange(key, 4, commitDescriptorBytesLength + 4));
    }

    public Map<CommitDescriptor, Set<String>> computeFilesThatDontNeedToBeReparsed() throws StorageException {
        final ConcurrentHashMap.KeySetView errorMessage = ConcurrentHashMap.newKeySet();
        final ConcurrentHashMap filesWithPotentialTokenChange = new ConcurrentHashMap();
        final ConcurrentHashMap filesWithPotentialIncludeTreeChange = new ConcurrentHashMap();
        this.store.scan(new byte[0], new IKeyValueCallback(){

            public void callback(byte[] key, byte @Nullable [] value) {
                int commitDescriptorBytesLength = ByteArrayUtils.readIntFromStartOfArray((byte[])key);
                int offset = 4 + commitDescriptorBytesLength;
                CommitDescriptor commit = CommitDescriptor.fromBranchTimestampKeyWithSeparator((byte[])Arrays.copyOfRange(key, 4, offset));
                byte storageKeyPrefix = key[offset];
                ++offset;
                if (storageKeyPrefix == EStorageKeyPrefix.POTENTIAL_TOKEN_CHANGE.byteValue[0]) {
                    filesWithPotentialTokenChange.computeIfAbsent(commit, k -> new HashSet()).add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, offset, key.length)));
                } else if (storageKeyPrefix == EStorageKeyPrefix.CHANGED_INCLUDE_TREE.byteValue[0]) {
                    filesWithPotentialIncludeTreeChange.computeIfAbsent(commit, k -> new HashSet()).add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, offset, key.length)));
                } else if (errorMessage.isEmpty()) {
                    errorMessage.add("Commit " + commit.toServiceCallFormat() + ": Found index entry with invalid storage key prefix " + storageKeyPrefix);
                }
            }
        });
        if (!errorMessage.isEmpty()) {
            throw new StorageException((String)errorMessage.stream().findAny().get());
        }
        HashMap<CommitDescriptor, Set<String>> result = new HashMap<CommitDescriptor, Set<String>>();
        for (Map.Entry entry : filesWithPotentialIncludeTreeChange.entrySet()) {
            CommitDescriptor commit = (CommitDescriptor)entry.getKey();
            Set pathsIncludingChangedFiles = (Set)entry.getValue();
            Set pathsWithPotentialTokenChange = filesWithPotentialTokenChange.getOrDefault(commit, new HashSet());
            result.put(commit, CollectionUtils.differenceSet((Collection)pathsIncludingChangedFiles, (Collection[])new Collection[]{pathsWithPotentialTokenChange}));
        }
        return result;
    }

    private static enum EStorageKeyPrefix {
        POTENTIAL_TOKEN_CHANGE(1),
        CHANGED_INCLUDE_TREE(2);

        private final byte[] byteValue;

        private EStorageKeyPrefix(byte prefix) {
            this.byteValue = new byte[]{prefix};
        }
    }
}

