/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.resolution_strategy;

import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.utils.EResourceType;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class IssueItemResourceResolutionStrategy
implements IResourceResolutionStrategy {
    private final ProjectStorageSystem projectStorageSystem;
    private final UniformPath.EType uniformPathType;

    public IssueItemResourceResolutionStrategy(ProjectStorageSystem projectStorageSystem, UniformPath.EType uniformPathType) {
        this.projectStorageSystem = projectStorageSystem;
        this.uniformPathType = uniformPathType;
    }

    private IssueIndex openIndex() throws StorageException {
        return (IssueIndex)this.projectStorageSystem.openProjectIndex(IssueIndex.class, null);
    }

    @Override
    public ContainerInfo getContainerInfoForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return (ContainerInfo)TeamscaleIssueId.calculateBasedOnUniformPath((UniformPath)uniformPath, type -> this.getRootContainerInfo(uniformPath), (type, connectorId) -> this.getConnectorContainerInfo(uniformPath, (String)connectorId), (ignored1, ignored2) -> null);
    }

    private ContainerInfo getRootContainerInfo(UniformPath uniformPath) throws StorageException {
        IssueIndex issueIndex = this.openIndex();
        List<@NonNull String> allConnectors = issueIndex.getAllConnectorIds();
        ContainerInfo containerInfo = new ContainerInfo(uniformPath.toString());
        for (String connector : allConnectors) {
            containerInfo.insertOrUpdateChildContainer(connector, "");
        }
        return containerInfo;
    }

    private ContainerInfo getConnectorContainerInfo(UniformPath uniformPath, String connectorId) throws StorageException {
        IssueIndex issueIndex = this.openIndex();
        ContainerInfo containerInfo = new ContainerInfo(uniformPath.toString());
        List<TeamscaleIssueId> issues = issueIndex.getAllKeysForConnector(connectorId);
        for (TeamscaleIssueId issue : issues) {
            containerInfo.insertOrUpdateChildElementWithHash(issue.computeUniformPath(this.uniformPathType).toString(), ContainerInfo.calculateContentDigest(issue.toString()));
        }
        return containerInfo;
    }

    @Override
    public List<ContainerInfo> getContainerInfosForPaths(List<UniformPath> uniformPaths, HistoryAccessOption historyAccessOption) throws StorageException {
        return CollectionUtils.mapWithException(uniformPaths, path -> this.getContainerInfoForPath((UniformPath)path, historyAccessOption));
    }

    @Override
    public EResourceType getResourceTypeForPath(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return (EResourceType)((Object)TeamscaleIssueId.calculateBasedOnUniformPath((UniformPath)uniformPath, ignored -> EResourceType.CONTAINER, (ignored1, ignored2) -> EResourceType.CONTAINER, (ignored1, ignored2) -> EResourceType.FILE));
    }

    @Override
    public Map<String, EResourceType> getResourceChildTypesForPath(UniformPath uniformPath, boolean includeChildFullPath, HistoryAccessOption historyAccessOption) throws StorageException {
        return (Map)TeamscaleIssueId.calculateBasedOnUniformPath((UniformPath)uniformPath, ignored -> this.getRootResourceInfos(uniformPath, includeChildFullPath), (ignored, connectorId) -> this.getConnectorChildTypes(uniformPath, (String)connectorId, includeChildFullPath), (ignored1, ignored2) -> CollectionUtils.emptyMap());
    }

    private Map<String, EResourceType> getRootResourceInfos(UniformPath uniformPath, boolean includeChildFullPath) throws StorageException {
        Function<String, String> keyMapper = IssueItemResourceResolutionStrategy.getKeyMapper(uniformPath, includeChildFullPath);
        return this.openIndex().getAllConnectorIds().stream().collect(Collectors.toMap(keyMapper, ignored -> EResourceType.CONTAINER));
    }

    private Map<String, EResourceType> getConnectorChildTypes(UniformPath uniformPath, String connectorId, boolean includeChildFullPath) throws StorageException {
        List<TeamscaleIssueId> issues = this.openIndex().getAllKeysForConnector(connectorId);
        return issues.stream().map(TeamscaleIssueId::getExternalId).collect(Collectors.toMap(IssueItemResourceResolutionStrategy.getKeyMapper(uniformPath, includeChildFullPath), ignored -> EResourceType.FILE));
    }

    private static @NonNull Function<String, String> getKeyMapper(UniformPath uniformPath, boolean includeChildFullPath) {
        if (includeChildFullPath) {
            return path -> uniformPath.resolve(RelativeUniformPath.of((String[])new String[]{path})).toString();
        }
        return Function.identity();
    }
}

