/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.user.User;
import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.issue_reference.SpecItemReferenceElement;
import com.teamscale.index.issue_reference.SpecItemRelationReference;
import com.teamscale.index.issue_reference.SpecItemVerificationRetriever;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyUtils;
import com.teamscale.index.resource.retrieval_strategy.StoredQueryMetricRetrievalStrategyBase;
import com.teamscale.index.resource.retrieval_strategy.computation.SpecItemMetricCalculator;
import com.teamscale.index.tests.SpecItemTestReferenceIndex;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.keyed.query.trend.SpecItemTrendItem;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.concurrent.MoreExecutors;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class SpecItemQueryMetricRetrievalStrategy
extends StoredQueryMetricRetrievalStrategyBase {
    private static final String MAX_THREADS_VM_OPTION = "com.teamscale.specitem-query-metric-retrieval.max-threads";
    private static final int MAX_THREADS = Integer.getInteger("com.teamscale.specitem-query-metric-retrieval.max-threads", 1);
    private static final IParallelTaskExecutor PARALLEL_TASK_EXECUTOR = SpecItemQueryMetricRetrievalStrategy.initParallelTaskExecutor();
    private final UniformPath.EType itemUniformPathType;
    private final IMetricRetrievalStrategy itemSpecificDelegate;

    public SpecItemQueryMetricRetrievalStrategy(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, UniformPath.EType itemUniformPathType, IMetricRetrievalStrategy itemSpecificDelegate) {
        super(projectStorageSystem, globalStorageSystem, currentUser, StoredQueryIndex.EStoredQueryType.SPEC_ITEM);
        this.itemUniformPathType = itemUniformPathType;
        this.itemSpecificDelegate = itemSpecificDelegate;
    }

    private static IParallelTaskExecutor initParallelTaskExecutor() {
        if (MAX_THREADS <= 1) {
            return IParallelTaskExecutor.sameThread();
        }
        AtomicInteger threadIdFactory = new AtomicInteger();
        ThreadFactory threadFactory = runnable -> new Thread(runnable, "specitem-query-metric-retrieval-" + threadIdFactory.getAndIncrement());
        ExecutorService executorService = MoreExecutors.newCachedThreadPool((int)1, (int)MAX_THREADS, (ThreadFactory)threadFactory);
        return IParallelTaskExecutor.forExecutorService((ExecutorService)TeamscaleLogAppender.wrap((ExecutorService)executorService));
    }

    @Override
    protected MetricDirectorySchema createMetricSchema() throws StorageException {
        ArrayList<MetricDirectorySchemaEntry> entries = new ArrayList<MetricDirectorySchemaEntry>((Collection<MetricDirectorySchemaEntry>)super.createMetricSchema().getAllEntries());
        entries.add(new MetricDirectorySchemaEntry("Test Reference Count", "Count of tests referencing the spec items", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.of(EMetricProperty.SIZE_METRIC, EMetricProperty.LOW_IS_BAD)));
        entries.add(new MetricDirectorySchemaEntry("Spec Item Coverage", "The ratio of tested items versus all the available items", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.of(EMetricProperty.RATIO_METRIC, EMetricProperty.LOW_IS_BAD)));
        entries.add(new MetricDirectorySchemaEntry("Code Reference Count", "Count of spec item references from production code", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.of(EMetricProperty.SIZE_METRIC, EMetricProperty.LOW_IS_BAD)));
        entries.add(new MetricDirectorySchemaEntry("Code Reference Coverage", "The ratio of items referenced from production code versus all the available items", MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.of(EMetricProperty.RATIO_METRIC, EMetricProperty.LOW_IS_BAD)));
        entries.addAll((Collection<MetricDirectorySchemaEntry>)this.itemSpecificDelegate.getMetricDirectorySchema().getAllEntries());
        return new MetricDirectorySchema(entries);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        QueryResult queryResult = this.getQueryResult(uniformPath, historyAccessOption);
        if (queryResult == null) {
            return null;
        }
        Map<TeamscaleIssueId, MetricDirectoryEntry> matchedItemMetrics = this.getItemMetrics(queryResult.specItemIds(), historyAccessOption);
        MetricDirectoryEntry result = this.computeQueryMetricDirectoryEntry(uniformPath, queryResult, matchedItemMetrics.values(), historyAccessOption, Collections.emptyList());
        CCSMAssert.isTrue((result.getValues().length == this.getMetricDirectorySchema(historyAccessOption).size() ? 1 : 0) != 0, (String)"Assuming metric values and schema to match.");
        return result;
    }

    private MetricDirectoryEntry computeQueryMetricDirectoryEntry(UniformPath uniformPath, QueryResult queryResult, Collection<MetricDirectoryEntry> itemsMetricEntries, HistoryAccessOption historyAccessOption, List<MetricDirectoryEntry> childEntries) throws StorageException {
        MetricDirectorySchema metricSchema = this.itemSpecificDelegate.getMetricDirectorySchema(historyAccessOption);
        Object[] additionalMetricValues = MetricRetrievalStrategyUtils.aggregateEntries(uniformPath.toString(), itemsMetricEntries, metricSchema).getValues();
        Object[] metricValues = SpecItemQueryMetricRetrievalStrategy.getMetricValues(queryResult);
        MetricDirectoryEntry entry = new MetricDirectoryEntry(uniformPath.toString(), MetricRetrievalStrategyUtils.concatArrays(metricValues, additionalMetricValues));
        HashMap<String, Object[]> childMetrics = new HashMap<String, Object[]>();
        for (MetricDirectoryEntry itemsMetricEntry : childEntries) {
            childMetrics.put(itemsMetricEntry.getUniformPath(), itemsMetricEntry.getValues());
        }
        entry.setChildMetrics(childMetrics);
        return entry;
    }

    @Override
    protected List<MetricDirectoryEntry> getMetricDirectoryEntries(UniformPath queryPath, HistoryAccessOption historyAccessOption) throws StorageException {
        QueryResult queryResult = this.getQueryResult(queryPath, historyAccessOption);
        if (queryResult == null) {
            return Collections.emptyList();
        }
        Map<TeamscaleIssueId, MetricDirectoryEntry> itemMetrics = this.getItemMetrics(queryResult.specItemIds(), historyAccessOption);
        ArrayList<MetricDirectoryEntry> entries = new ArrayList<MetricDirectoryEntry>(itemMetrics.size() + 1);
        for (Map.Entry<TeamscaleIssueId, MetricDirectoryEntry> metricEntryForItem : itemMetrics.entrySet()) {
            TeamscaleIssueId issueId = metricEntryForItem.getKey();
            MetricDirectoryEntry itemMetricEntry = metricEntryForItem.getValue();
            MetricDirectoryEntry queryAndItemMetricEntry = SpecItemQueryMetricRetrievalStrategy.computeItemMetricDirectoryEntry(SpecItemQueryMetricRetrievalStrategy.buildItemSpecificUniformPath(queryPath, issueId), itemMetricEntry, queryResult.forSingleSpecItem(issueId));
            entries.add(queryAndItemMetricEntry);
        }
        MetricDirectoryEntry rootEntry = this.computeQueryMetricDirectoryEntry(queryPath, queryResult, itemMetrics.values(), historyAccessOption, entries);
        entries.add(rootEntry);
        return entries;
    }

    private @NonNull Map<TeamscaleIssueId, MetricDirectoryEntry> getItemMetrics(Collection<TeamscaleIssueId> specItems, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectorySchema schema = this.itemSpecificDelegate.getMetricDirectorySchema(historyAccessOption);
        HashMap<TeamscaleIssueId, MetricDirectoryEntry> entriesForItems = new HashMap<TeamscaleIssueId, MetricDirectoryEntry>();
        for (TeamscaleIssueId specItem : specItems) {
            UniformPath path = specItem.computeUniformPath(this.itemUniformPathType);
            MetricDirectoryEntry entry = this.itemSpecificDelegate.getMetricDirectoryEntry(path, historyAccessOption);
            if (entry == null) continue;
            CCSMAssert.isTrue((entry.getValues().length == schema.size() ? 1 : 0) != 0, (String)"Schema and metric values supposed to match");
            entriesForItems.put(specItem, entry);
        }
        return entriesForItems;
    }

    private static @NonNull MetricDirectoryEntry computeItemMetricDirectoryEntry(UniformPath itemUniformPath, MetricDirectoryEntry itemMetricEntry, QueryResult singleItemQueryResult) {
        Object[] queryMetricValuesForSingleItem = SpecItemQueryMetricRetrievalStrategy.getMetricValues(singleItemQueryResult);
        Object[] itemMetricValues = itemMetricEntry.getValues();
        return new MetricDirectoryEntry(itemUniformPath.toString(), MetricRetrievalStrategyUtils.concatArrays(queryMetricValuesForSingleItem, itemMetricValues));
    }

    private QueryResult getQueryResult(UniformPath queryPath, HistoryAccessOption historyAccessOption) throws StorageException {
        WorkItemHistoryIndexAggregation<SpecItem> historyIndexAggregation = WorkItemHistoryIndexAggregation.forSpecItems(this.projectStorageSystem, historyAccessOption);
        List<String> specItemIds = this.getIssueIds(queryPath, historyIndexAggregation, historyAccessOption);
        if (specItemIds == null) {
            return null;
        }
        List<List<SpecItemCodeReference>> codeReferences = this.getCodeReferences(specItemIds, historyAccessOption);
        List<HashSet<PartitionAndPath>> testReferences = this.getTestReferences(specItemIds, historyAccessOption);
        List<Set<SpecItemReferenceElement>> verifiedSpecItemReferences = this.getSpecItemVerifiesReferences(specItemIds, historyAccessOption);
        return QueryResult.of(specItemIds, codeReferences, testReferences, verifiedSpecItemReferences);
    }

    private List<List<SpecItemCodeReference>> getCodeReferences(List<String> specItemIds, HistoryAccessOption historyAccessOption) throws StorageException {
        SpecItemCodeReferenceIndex specItemCodeReferenceIndex = (SpecItemCodeReferenceIndex)this.projectStorageSystem.openProjectIndex(SpecItemCodeReferenceIndex.class, historyAccessOption);
        return specItemCodeReferenceIndex.getSpecItemCodeReferences(specItemIds);
    }

    private List<HashSet<PartitionAndPath>> getTestReferences(List<String> specItemIds, HistoryAccessOption historyAccessOption) throws StorageException {
        SpecItemTestReferenceIndex specItemTestReferenceIndex = (SpecItemTestReferenceIndex)this.projectStorageSystem.openProjectIndex(SpecItemTestReferenceIndex.class, historyAccessOption);
        return specItemTestReferenceIndex.getTestReferences(specItemIds);
    }

    private List<Set<SpecItemReferenceElement>> getSpecItemVerifiesReferences(List<String> specItemIds, HistoryAccessOption historyAccessOption) throws StorageException {
        SpecItemVerificationRetriever retriever = new SpecItemVerificationRetriever(this.globalStorageSystem, this.projectStorageSystem);
        @Nullable List<@Nullable SpecItemRelationReference> specItemReferencesForIssueIds = retriever.retrieveSpecItemsAreVerifiedBy(specItemIds.stream().map(TeamscaleIssueId::fromInternalId).toList(), historyAccessOption, true);
        ArrayList<Set<SpecItemReferenceElement>> result = new ArrayList<Set<SpecItemReferenceElement>>();
        if (specItemReferencesForIssueIds == null) {
            return result;
        }
        for (SpecItemRelationReference specItemReferencesForIssue : specItemReferencesForIssueIds) {
            if (specItemReferencesForIssue == null) {
                result.add(Set.of());
                continue;
            }
            result.add(specItemReferencesForIssue.targets());
        }
        return result;
    }

    @Override
    protected String getBasicMetricName() {
        return "Spec Items";
    }

    protected WorkItemHistoryIndexAggregation<SpecItem> getHistoryIndex(CommitDescriptor commit) throws StorageException {
        return WorkItemHistoryIndexAggregation.forSpecItems(this.projectStorageSystem, commit);
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        NavigableMap<Long, SpecItemTrendItem> specItemQueryTrend = this.getSpecItemQueryTrend(uniformPath, start, end);
        return this.processSpecItemQueryTrend(start, end, specItemQueryTrend);
    }

    private NavigableMap<Long, SpecItemTrendItem> getSpecItemQueryTrend(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        StoredQueryDescriptor queryDescriptor = SpecItemQueryMetricRetrievalStrategy.getQueryDescriptorForPath(uniformPath, this.getStoredQueryIndex());
        TreeMap<Long, SpecItemTrendItem> specItemTrend = new TreeMap<Long, SpecItemTrendItem>(QueryableEntityUtils.getSpecItemTrend(this.getHistoryIndex(end), queryDescriptor.getQuery(), QueryableEntityUtils.QueryContext.ofTrend(this.projectStorageSystem, this.globalStorageSystem, this.currentUser, this.storedQueryType, start.getTimestamp(), end.getTimestamp(), end.getBranchName())).toMap());
        if (specItemTrend.floorEntry(start.getTimestamp()) == null) {
            QueryResult queryResult = this.getQueryResult(uniformPath, HistoryAccessOption.readCommit((CommitDescriptor)start));
            CCSMAssert.isNotNull((Object)queryResult, () -> String.format("Expected \"%s\" to be not null for uniform path %s and commit %s", "queryResult", uniformPath, start));
            specItemTrend.put(start.getTimestamp(), queryResult.toTrendItem());
        }
        CCSMAssert.isFalse((boolean)specItemTrend.isEmpty(), (String)"Expected spec item trend to not be empty");
        return specItemTrend;
    }

    private @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    TrendIndexBase.TrendEntry<Object[]>> processSpecItemQueryTrend(CommitDescriptor start, CommitDescriptor end, NavigableMap<Long, SpecItemTrendItem> queryTrend) throws StorageException {
        Map<TeamscaleIssueId, NavigableMap<Long, Object[]>> specItemsTrends = this.buildTrendPerSpecItem(start, end, queryTrend);
        return this.mergeTrends(queryTrend, specItemsTrends);
    }

    private List<TrendIndexBase.TrendEntry<Object[]>> mergeTrends(NavigableMap<Long, SpecItemTrendItem> queryTrend, Map<TeamscaleIssueId, NavigableMap<Long, Object[]>> specItemsTrends) throws StorageException {
        MetricDirectorySchema itemSchema = this.itemSpecificDelegate.getMetricDirectorySchema();
        SortedSet<Long> allChangeTimestamps = SpecItemQueryMetricRetrievalStrategy.getAllChangeTimestamps(queryTrend, specItemsTrends);
        ArrayList<TrendIndexBase.TrendEntry<Object[]>> result = new ArrayList<TrendIndexBase.TrendEntry<Object[]>>(allChangeTimestamps.size());
        Iterator iterator = allChangeTimestamps.iterator();
        while (iterator.hasNext()) {
            long changeTimestamp = (Long)iterator.next();
            SpecItemTrendItem queryTrendItem = queryTrend.floorEntry(changeTimestamp).getValue();
            ArrayList<Object[]> itemMetrics = new ArrayList<Object[]>(queryTrendItem.getSpecItemCount());
            for (TeamscaleIssueId specItem : queryTrendItem.getSpecItems()) {
                itemMetrics.add(specItemsTrends.get(specItem).floorEntry(changeTimestamp).getValue());
            }
            result.add((TrendIndexBase.TrendEntry<Object[]>)new TrendIndexBase.TrendEntry(changeTimestamp, (Object)SpecItemQueryMetricRetrievalStrategy.mergeQueryAndItemMetrics(SpecItemQueryMetricRetrievalStrategy.getMetricValues(queryTrendItem), itemMetrics, itemSchema)));
        }
        return result;
    }

    private static @NonNull SortedSet<Long> getAllChangeTimestamps(NavigableMap<Long, SpecItemTrendItem> queryTrend, Map<TeamscaleIssueId, NavigableMap<Long, Object[]>> specItemTrends) {
        TreeSet<Long> allChangeTimestamps = new TreeSet<Long>(queryTrend.keySet());
        for (NavigableMap<Long, Object[]> specItemTrend : specItemTrends.values()) {
            allChangeTimestamps.addAll(specItemTrend.keySet());
        }
        return allChangeTimestamps;
    }

    private static Object[] mergeQueryAndItemMetrics(Object[] queryMetrics, List<Object[]> itemMetrics, MetricDirectorySchema schema) {
        Object[] aggregatedItemMetrics = MetricRetrievalStrategyUtils.aggregateMetrics(itemMetrics, schema);
        return MetricRetrievalStrategyUtils.concatArrays(queryMetrics, aggregatedItemMetrics);
    }

    private Map<TeamscaleIssueId, NavigableMap<Long, Object[]>> buildTrendPerSpecItem(CommitDescriptor start, CommitDescriptor end, NavigableMap<Long, SpecItemTrendItem> queryTrend) throws StorageException {
        Map<TeamscaleIssueId, Long> firstItemOccurrences = SpecItemQueryMetricRetrievalStrategy.getFirstItemOccurrences(queryTrend);
        try {
            List<Callable> jobs = firstItemOccurrences.entrySet().stream().map(entry -> this.getTrendJob((Map.Entry<TeamscaleIssueId, Long>)entry, start, end)).toList();
            return (Map)PARALLEL_TASK_EXECUTOR.executeInParallelAndCombine(jobs, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof StorageException) {
                StorageException storageException = (StorageException)throwable;
                throw storageException;
            }
            throw new IllegalStateException("Error during spec item trend computation", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Spec item trend computation was interrupted", e);
        }
    }

    private static @NonNull Map<TeamscaleIssueId, Long> getFirstItemOccurrences(NavigableMap<Long, SpecItemTrendItem> queryTrend) {
        HashMap<TeamscaleIssueId, Long> firstItemOccurrences = new HashMap<TeamscaleIssueId, Long>();
        for (Map.Entry queryTrendEntry : queryTrend.entrySet()) {
            long queryTrendEntryTimestamp = (Long)queryTrendEntry.getKey();
            ((SpecItemTrendItem)queryTrendEntry.getValue()).getSpecItems().forEach(matchedItem -> firstItemOccurrences.putIfAbsent((TeamscaleIssueId)matchedItem, queryTrendEntryTimestamp));
        }
        return firstItemOccurrences;
    }

    private @NonNull Callable<Map.Entry<TeamscaleIssueId, NavigableMap<Long, Object[]>>> getTrendJob(Map.Entry<TeamscaleIssueId, Long> entry, CommitDescriptor start, CommitDescriptor end) {
        return () -> Map.entry((TeamscaleIssueId)entry.getKey(), this.getSpecItemTrend(start, end, (TeamscaleIssueId)entry.getKey(), (Long)entry.getValue()));
    }

    private NavigableMap<Long, Object[]> getSpecItemTrend(CommitDescriptor start, CommitDescriptor end, TeamscaleIssueId specItemId, long firstOccurrenceInQueryTrend) throws StorageException {
        MetricDirectoryEntry directoryEntry;
        UniformPath path = specItemId.computeUniformPath(this.itemUniformPathType);
        List<TrendIndexBase.TrendEntry<Object[]>> history = this.itemSpecificDelegate.extractMetricHistory(path, start, end);
        TreeMap<Long, Object[]> result = new TreeMap<Long, Object[]>();
        for (TrendIndexBase.TrendEntry<Object[]> trendEntry : history) {
            result.put(trendEntry.timestamp(), (Object[])trendEntry.value());
        }
        if (result.floorKey(firstOccurrenceInQueryTrend) == null && (directoryEntry = this.itemSpecificDelegate.getMetricDirectoryEntry(path, HistoryAccessOption.readCommit((CommitDescriptor)new CommitDescriptor(end.getBranchName(), firstOccurrenceInQueryTrend)))) != null) {
            result.put(firstOccurrenceInQueryTrend, directoryEntry.getValues());
        }
        if (result.isEmpty()) {
            throw new IllegalStateException("Unable to build trend for item " + String.valueOf(specItemId) + " start: " + String.valueOf(start) + " end: " + String.valueOf(end));
        }
        return result;
    }

    private static Object[] getMetricValues(QueryResult queryResult) {
        return SpecItemQueryMetricRetrievalStrategy.getMetricValues(queryResult.toTrendItem());
    }

    private static Object[] getMetricValues(SpecItemTrendItem trendItem) {
        double specItemCount = trendItem.getSpecItemCount();
        double testReferenceCount = trendItem.getTestReferencesCount();
        double specItemCoverage = SpecItemMetricCalculator.computeSpecItemCoverageMetric(trendItem.getTestedItemsCount(), trendItem.getSpecItemCount());
        double codeReferenceCount = trendItem.getProductionCodeReferencesCount();
        double codeReferenceCoverage = SpecItemMetricCalculator.computeSpecItemCoverageMetric(trendItem.getProductionItemsCount(), trendItem.getSpecItemCount());
        return new Object[]{specItemCount, testReferenceCount, specItemCoverage, codeReferenceCount, codeReferenceCoverage};
    }

    private static UniformPath buildItemSpecificUniformPath(UniformPath queryPath, TeamscaleIssueId itemId) {
        ArrayList<String> segments = new ArrayList<String>((Collection<String>)queryPath.getPathSegments());
        segments.add(itemId.getInternalId());
        return UniformPath.ofSegments((UniformPath.EType)queryPath.getType(), segments);
    }

    private record QueryResult(List<TeamscaleIssueId> specItemIds, Map<TeamscaleIssueId, List<SpecItemCodeReference>> references, Map<TeamscaleIssueId, List<PartitionAndPath>> testReferences, Map<TeamscaleIssueId, Set<SpecItemReferenceElement>> verifiedSpecItemReferences) {
        private static QueryResult of(List<String> specItemIds, List<? extends List<SpecItemCodeReference>> codeReferences, List<? extends Set<PartitionAndPath>> testReferences, List<Set<SpecItemReferenceElement>> verifiedSpecItemReferences) {
            ArrayList<TeamscaleIssueId> parsedSpecItemIds = new ArrayList<TeamscaleIssueId>(specItemIds.size());
            HashMap<TeamscaleIssueId, List<SpecItemCodeReference>> parsedReferences = new HashMap<TeamscaleIssueId, List<SpecItemCodeReference>>();
            HashMap<TeamscaleIssueId, Set<SpecItemReferenceElement>> parsedVerifiedSpecItemReferences = new HashMap<TeamscaleIssueId, Set<SpecItemReferenceElement>>();
            HashMap<TeamscaleIssueId, List<PartitionAndPath>> parsedTestReferences = new HashMap<TeamscaleIssueId, List<PartitionAndPath>>();
            for (int i = 0; i < specItemIds.size(); ++i) {
                String specItemId = specItemIds.get(i);
                List<SpecItemCodeReference> specItemCodeReferences = codeReferences.get(i);
                Set<SpecItemReferenceElement> verifiedSpecItems = verifiedSpecItemReferences.get(i);
                Set<PartitionAndPath> specItemTestReferences = testReferences.get(i);
                TeamscaleIssueId parsedSpecItemId = TeamscaleIssueId.fromInternalId((String)specItemId);
                parsedSpecItemIds.add(parsedSpecItemId);
                if (specItemCodeReferences != null) {
                    parsedReferences.put(parsedSpecItemId, specItemCodeReferences);
                }
                if (specItemTestReferences != null) {
                    parsedTestReferences.put(parsedSpecItemId, new ArrayList<PartitionAndPath>(specItemTestReferences));
                }
                parsedVerifiedSpecItemReferences.put(parsedSpecItemId, verifiedSpecItems);
            }
            return new QueryResult(parsedSpecItemIds, parsedReferences, parsedTestReferences, parsedVerifiedSpecItemReferences);
        }

        private SpecItemTrendItem toTrendItem() {
            int verifiedSpecItemsCount = SpecItemMetricCalculator.computeSpecItemVerifiesCountMetric(this.references.values(), this.testReferences.values(), this.verifiedSpecItemReferences.values());
            int testedItemsCount = SpecItemMetricCalculator.computeTestedItemsCount(this.specItemIds, this.references, this.testReferences, this.verifiedSpecItemReferences);
            int nonTestCodeReferences = SpecItemMetricCalculator.computeProductionCodeReferencesCount(this.references.values());
            int nonTestItemsCount = SpecItemMetricCalculator.computeItemsWithProductionCodeReferencesCount(this.references);
            return new SpecItemTrendItem(this.specItemIds, verifiedSpecItemsCount, testedItemsCount, nonTestCodeReferences, nonTestItemsCount);
        }

        private QueryResult forSingleSpecItem(TeamscaleIssueId specItemId) {
            return new QueryResult(List.of(specItemId), Collections.singletonMap(specItemId, this.references.get(specItemId)), Collections.singletonMap(specItemId, this.testReferences.get(specItemId)), Collections.singletonMap(specItemId, this.verifiedSpecItemReferences.get(specItemId)));
        }
    }
}

