/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.content;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.simulink.DataDictionaryLoader;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.EExtendedResourceType;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.simulink.subsystems.SimulinkFileReferenceIndex;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkFileSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BinaryElementIndex binaryElementIndex;
    @DeltaSource(value=BinaryElementIndex.class)
    private KeyDelta binaryElementDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ExtendedResourceTypeIndex extendedResourceTypeIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SimulinkModelInfoIndex modelInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SimulinkDataDictionaryIndex dataDictionaryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SimulinkFileReferenceIndex fileReferenceIndex;

    public void execute() throws StorageException {
        this.processSimulinkModels();
        this.processSimulinkDataDictionaries();
    }

    private void processSimulinkModels() throws StorageException {
        List<String> deletedKeys = SimulinkFileSynchronizer.filterSimulinkModels(this.binaryElementDelta.getDeletedKeysAsStrings());
        if (!deletedKeys.isEmpty()) {
            this.extendedResourceTypeIndex.removeEntries(deletedKeys);
            this.modelInfoIndex.removeByUniformPaths(deletedKeys);
        }
        List<String> changedKeys = SimulinkFileSynchronizer.filterSimulinkModels(this.binaryElementDelta.getAddedOrChangedKeysAsStrings());
        LazyModelLoader modelLoader = new LazyModelLoader(this.binaryElementIndex);
        modelLoader.preloadModels(changedKeys);
        for (String uniformPath : changedKeys) {
            SimulinkModel model = modelLoader.getModelByUniformPath(uniformPath).orElse(null);
            this.modelInfoIndex.addOrUpdateModel(uniformPath, model);
            this.fileReferenceIndex.addOrUpdateModel(uniformPath, model);
        }
        if (!changedKeys.isEmpty()) {
            this.extendedResourceTypeIndex.addResourceType(changedKeys, EExtendedResourceType.SIMULINK_MODEL);
        }
    }

    private void processSimulinkDataDictionaries() throws StorageException {
        List<String> deletedKeys = SimulinkFileSynchronizer.filterSimulinkDataDictionaries(this.binaryElementDelta.getDeletedKeysAsStrings());
        if (!deletedKeys.isEmpty()) {
            this.dataDictionaryIndex.deleteDataDictionaryFiles(deletedKeys);
            this.extendedResourceTypeIndex.removeEntries(deletedKeys);
        }
        List<String> changedKeys = SimulinkFileSynchronizer.filterSimulinkDataDictionaries(this.binaryElementDelta.getAddedOrChangedKeysAsStrings());
        DataDictionaryLoader dictionaryLoader = new DataDictionaryLoader(this.binaryElementIndex, this.dataDictionaryIndex);
        dictionaryLoader.preloadDictionaries(changedKeys);
        for (int i = 0; i < changedKeys.size(); ++i) {
            String uniformPath = changedKeys.get(i);
            this.dataDictionaryIndex.addOrUpdateDataDictionaryFile(uniformPath, dictionaryLoader.getDictionaryByUniformPath(uniformPath).orElse(null));
        }
        if (!changedKeys.isEmpty()) {
            this.extendedResourceTypeIndex.addResourceType(changedKeys, EExtendedResourceType.SIMULINK_DATA_DICTIONARY);
        }
    }

    public static List<String> filterSimulinkModels(List<String> paths) {
        return CollectionUtils.filter(paths, SimulinkUtils::isSimulinkModelPath);
    }

    private static List<String> filterSimulinkDataDictionaries(List<String> paths) {
        return CollectionUtils.filter(paths, SimulinkUtils::isSimulinkDataDictionary);
    }
}

