/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;

public final class SimulinkPropagationUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static @NonNull SimulinkBlock extractReferencedBlock(@NonNull SimulinkModel model, @Nullable String sourceBlock) {
        if (sourceBlock == null) {
            return model;
        }
        String[] sourceBlockParts = sourceBlock.split("/");
        if (sourceBlockParts.length <= 1) {
            LOGGER.error("Invalid source block detected (should have at least two parts separated by '/'): " + sourceBlock);
            return model;
        }
        SimulinkModel parentBlock = model;
        for (int i = 1; i < sourceBlockParts.length; ++i) {
            if ((parentBlock = parentBlock.getSubBlock(sourceBlockParts[i])) != null) continue;
            LOGGER.error("Block with ID " + sourceBlock + " not found in library " + model.getUniformPath() + ". Assuming library root to be referenced.");
            return model;
        }
        return parentBlock;
    }

    private SimulinkPropagationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

