/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="simulink-tracelink-abbr", options={EStorageOption.BRANCHED})
public class TracelinkAbbreviationIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "simulink-tracelink-abbr";
    private final ValueIndex<String> delegate;

    public TracelinkAbbreviationIndex(IStore store) {
        this.delegate = ValueIndex.forString((IStore)store);
    }

    public Optional<String> replaceAbbreviation(String tracelink, String modelName, String abbreviation) throws StorageException {
        String abbreviationPath = UniformPathUtils.concatenate((String[])new String[]{modelName, abbreviation});
        String abbreviationResolved = (String)this.delegate.getValue(abbreviationPath);
        if (abbreviationResolved == null) {
            return Optional.empty();
        }
        return Optional.of(tracelink.replace(TracelinkAbbreviationIndex.generateAbbreviationTag(abbreviation), abbreviationResolved));
    }

    private static String generateAbbreviationTag(String abbreviation) {
        return "<" + abbreviation + ">";
    }

    public void setAbbreviations(PairList<String, String> abbreviationValues) throws StorageException {
        this.delegate.setValues(abbreviationValues);
    }

    @VisibleForTesting
    List<String> getAllKeys() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public @Nullable String getAbbreviation(String modelAndAbbreviation) throws StorageException {
        return (String)this.delegate.getValue(modelAndAbbreviation);
    }

    public void setAbbreviation(String modelAndAbbreviation, String modelAndDestination) throws StorageException {
        this.delegate.setValue(modelAndAbbreviation, (Object)modelAndDestination);
    }
}

