/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testcoverage.CoverageMetricSynchronizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class MethodCoverageMetricSynchronizer
extends CoverageMetricSynchronizerBase {
    public static final String ENABLE_METHOD_COVERAGE_PARAMETER_NAME = "enable-method-coverage";
    public static final String COVERABLE_METHODS_PARTITION = "test-coverable-methods";
    public static final String COVERED_METHODS_PARTITION = "test-covered-methods";
    @StepParameter(value="enable-method-coverage")
    private CodeScopeAware<Boolean> enableMethodCoverage;

    @Override
    protected void updateCoverageMetrics(CoverageMetricSynchronizerBase.CoveragePartitionGroup partitionGroup, List<String> pathsToUpdate) throws StorageException {
        PairList<String, LineCoverageInfo> coverageInfos = this.getLineCoverageInfosToUpdate(partitionGroup, true, pathsToUpdate);
        List<TokenElementInfo> elements = this.contentIndex.getTokenElements(coverageInfos.extractFirstList());
        PairList coverableMethodsData = new PairList();
        PairList coveredMethodsData = new PairList();
        for (int i = 0; i < coverageInfos.size(); ++i) {
            String uniformPath = (String)coverageInfos.getFirst(i);
            TokenElementInfo element = elements.get(i);
            LineCoverageInfo coverage = (LineCoverageInfo)coverageInfos.getSecond(i);
            MethodCoverageMetricSynchronizer.insertMethodCoverage(uniformPath, element, coverage, (PairList<String, Double>)coverableMethodsData, (PairList<String, Double>)coveredMethodsData);
        }
        this.storeData((PairList<String, Double>)coverableMethodsData, (PairList<String, Double>)coveredMethodsData, partitionGroup);
    }

    private static void insertMethodCoverage(String uniformPath, TokenElementInfo element, LineCoverageInfo coverage, PairList<String, Double> coverableMethodsData, PairList<String, Double> coveredMethodsData) {
        UnmodifiableList<ShallowEntity> entities = element.getShallowEntitiesWithoutPreprocessorTokens();
        int methodCount = 0;
        int coveredMethodCount = 0;
        if (entities != null) {
            List methods = ShallowEntityTraversalUtils.listMethodsNonRecursive(entities);
            CompactLines covered = coverage.getCoveredLines();
            CompactLines coverable = coverage.getAllCoverableLines();
            for (ShallowEntity method : methods) {
                if (MethodCoverageMetricSynchronizer.isAnyMethodLineContained(method, covered)) {
                    ++methodCount;
                    ++coveredMethodCount;
                    continue;
                }
                if (!MethodCoverageMetricSynchronizer.isAnyMethodLineContained(method, coverable)) continue;
                ++methodCount;
            }
        }
        coverableMethodsData.add((Object)uniformPath, (Object)methodCount);
        coveredMethodsData.add((Object)uniformPath, (Object)coveredMethodCount);
    }

    private static boolean isAnyMethodLineContained(ShallowEntity method, CompactLines lines) {
        for (int line = method.getStartLine(); line <= method.getEndLine(); ++line) {
            if (!lines.contains(line)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getDefaultCoverablePartitionName() {
        return COVERABLE_METHODS_PARTITION;
    }

    @Override
    protected String getDefaultCoveredPartitionName() {
        return COVERED_METHODS_PARTITION;
    }

    @Override
    protected CodeScopeAware<Boolean> getCodeScopeAwareCoverageEnablement() {
        return this.enableMethodCoverage;
    }
}

