/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.teamscale.index.testgap.query.TgaIssueAndMergeRequestOptions;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TgaRequestQueryOptions {
    private static final String SHOW_EXECUTED_METHODS_ONLY_PARAMETER_NAME = "only-executed-methods";
    private static final String EXECUTION_ONLY_PARAMETER_DOC = "If this parameter is given, the service disregards code changes and only assesses execution of methods.";
    @Parameter(description="If this parameter is given, the service disregards code changes and only assesses execution of methods.")
    @QueryParam(value="only-executed-methods")
    private boolean showExecutedMethodsOnly;
    @Parameter(description="Uniform path at which the request should focus on")
    @DefaultValue(value="")
    @QueryParam(value="uniform-path")
    private UniformPath uniformPath;
    @Parameter(description="The test uniform path for which coverage should be shown in the treemap. This is an exclusive alternative to test-query i.e. if given, test-query is ignored.")
    @QueryParam(value="test-uniform-path")
    private UniformPath testUniformPath;
    @Parameter(description="Test query that determines which coverage should be shown in the treemap. This is an exclusive alternative to test-uniform-path i.e. if test-uniform-path is given, this parameter is ignored.")
    @QueryParam(value="test-query")
    private String testQuery;
    @BeanParam
    private TgaIssueAndMergeRequestOptions tgaIssueAndMergeRequestOptions;

    @JsonCreator
    public TgaRequestQueryOptions() {
    }

    public TgaRequestQueryOptions(boolean showExecutedMethodsOnly, String issueId, boolean mergeRequestMode, UniformPath uniformPath, String mergeBaseCacheKey) {
        this.showExecutedMethodsOnly = showExecutedMethodsOnly;
        this.uniformPath = uniformPath;
        this.tgaIssueAndMergeRequestOptions = new TgaIssueAndMergeRequestOptions(issueId, mergeRequestMode, mergeBaseCacheKey, null);
    }

    public TgaRequestQueryOptions(boolean showExecutedMethodsOnly, String issueId, boolean mergeRequestMode, UniformPath uniformPath, String mergeBaseCacheKey, MergeRequestIdentifier mergeRequestIdentifier) {
        this.showExecutedMethodsOnly = showExecutedMethodsOnly;
        this.uniformPath = uniformPath;
        this.tgaIssueAndMergeRequestOptions = new TgaIssueAndMergeRequestOptions(issueId, mergeRequestMode, mergeBaseCacheKey, mergeRequestIdentifier);
    }

    public TgaRequestQueryOptions(UniformPath uniformPath, TgaIssueAndMergeRequestOptions tgaIssueAndMergeRequestOptions) {
        this.uniformPath = uniformPath;
        this.tgaIssueAndMergeRequestOptions = tgaIssueAndMergeRequestOptions;
    }

    public boolean isShowExecutedMethodsOnly() {
        return this.showExecutedMethodsOnly;
    }

    public String getIssueId() {
        return this.tgaIssueAndMergeRequestOptions.getIssueId();
    }

    public void setIssueId(String issueId) {
        this.tgaIssueAndMergeRequestOptions.setIssueId(issueId);
    }

    public boolean isMergeRequest() {
        return this.tgaIssueAndMergeRequestOptions.isMergeRequestMode();
    }

    public Optional<UniformPath> getUniformPath() {
        return Optional.ofNullable(this.uniformPath);
    }

    public UniformPath getTestUniformPath() {
        return this.testUniformPath;
    }

    public String getMergeBaseCacheKey() {
        return this.tgaIssueAndMergeRequestOptions.getMergeBaseCacheKey();
    }

    public MergeRequestIdentifier getMergeRequestIdentifier() {
        return this.tgaIssueAndMergeRequestOptions.getMergeRequestIdentifier();
    }

    public String getTestQuery() {
        return this.testQuery;
    }
}

