/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.report.result.processor.CoverageUnitTempIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.testgap.MethodInfoContainer;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.MethodIdMap;
import com.teamscale.index.testimpact.MethodLocationOffsetMapping;
import com.teamscale.index.testimpact.MethodToTestsMappingUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.MultiFileRangeCoverageInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.LineOffsetUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CoverageUnitIntegrator
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MethodInfoIndex methodInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private CoverageUnitToMethodsMapIndex newCoverageUnitToMethodsMapIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private MethodIdIndex methodIdIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @DeltaSource(value=CoverageUnitTempIndex.class)
    private KeyDelta coverageUnitDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CoverageUnitTempIndex coverageUnitTempIndex;
    private final Map<String, PairList<LineBasedRegion, MethodId>> methodInfoMap = new HashMap<String, PairList<LineBasedRegion, MethodId>>();

    public void execute() throws Exception {
        this.newCoverageUnitToMethodsMapIndex.addPartitions(new HashSet(this.coverageUnitTempIndex.getPartitions()));
        List partitionAndPaths = PartitionIndexBase.getPartitionAndPaths((Collection)this.coverageUnitDelta.getAllKeysAsStrings());
        MethodIdLookup methodIdLookup = new MethodIdLookup(this.methodIdIndex);
        MethodToTestsMappingUpdater changeOperations = new MethodToTestsMappingUpdater();
        long timestamp = this.getSchedulingCommit().getTimestamp();
        this.executeInParallelBatches(partitionAndPaths, coverageUnits -> {
            List<MultiFileRangeCoverageInfo> coverage = this.coverageUnitTempIndex.getCoverage((List<PartitionAndPath>)coverageUnits);
            this.prefetchMethodInfos(methodIdLookup, coverage);
            SetMap<PartitionAndPath, MethodId> methodInfoSetMap = this.convertToTestsToMethodsMapping((List<PartitionAndPath>)coverageUnits, coverage);
            this.newCoverageUnitToMethodsMapIndex.calculateChangeOperations(methodInfoSetMap, changeOperations);
            this.newCoverageUnitToMethodsMapIndex.overwriteTestToMethodsMapping(timestamp, methodInfoSetMap);
        });
        methodIdLookup.persist();
        this.newCoverageUnitToMethodsMapIndex.applyOperationsToMethodsToCoverageUnitMappings(changeOperations);
    }

    private SetMap<PartitionAndPath, MethodId> convertToTestsToMethodsMapping(List<PartitionAndPath> partitionAndPaths, List<MultiFileRangeCoverageInfo> multiFileRangeCoverageInfos) {
        SetMap methodInfoSetMap = new SetMap();
        CollectionUtils.forEach(partitionAndPaths, multiFileRangeCoverageInfos, (partitionAndPath, multiFileRangeCoverageInfo) -> {
            Set<MethodId> coveredMethods = this.aggregateMultiFileCoverageToMethods((MultiFileRangeCoverageInfo)multiFileRangeCoverageInfo);
            methodInfoSetMap.addAll(partitionAndPath, coveredMethods);
        });
        return methodInfoSetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchMethodInfos(MethodIdLookup methodIdLookup, Collection<MultiFileRangeCoverageInfo> coverageInfos) throws StorageException {
        List<String> allCoveredUniformPaths = coverageInfos.stream().flatMap(multiFileRangeCoverageInfo -> multiFileRangeCoverageInfo.getCoverage().keySet().stream()).distinct().collect(Collectors.toList());
        methodIdLookup.preload(allCoveredUniformPaths);
        Map<String, PairList<LineBasedRegion, MethodId>> map = this.methodInfoMap;
        synchronized (map) {
            HashSet pathsToLoad = CollectionUtils.differenceSet(allCoveredUniformPaths, (Collection[])new Collection[]{this.methodInfoMap.keySet()});
            List uniformPathPartitions = Lists.partition(new ArrayList(pathsToLoad), (int)1000);
            for (List uniformPathPartition : uniformPathPartitions) {
                this.prefetchMethodIds(methodIdLookup, UniformPathCompatibilityUtil.convertCollection((Collection)uniformPathPartition));
            }
        }
    }

    private void prefetchMethodIds(MethodIdLookup methodIdLookup, List<UniformPath> uniformPaths) throws StorageException {
        List<BasicTokenElementInfo> tokenElements = this.basicTokenElementIndex.getTokenElementsFor(uniformPaths);
        List<MethodInfoContainer> containers = this.methodInfoIndex.getMethodContainersWithoutCrossAnnotationInfo(uniformPaths);
        for (int i = 0; i < uniformPaths.size(); ++i) {
            if (containers.get(i) == null) continue;
            UniformPath uniformPath = uniformPaths.get(i);
            if (tokenElements.get(i) == null) {
                LOGGER.warn("Could not find TokenElementInfo for path: '" + String.valueOf(uniformPath) + "'. Skipping.");
                continue;
            }
            LineOffsetConverter converter = new LineOffsetConverter(tokenElements.get(i).getText());
            for (OffsetBasedRegion region : containers.get(i).keySet()) {
                LineBasedRegion lineBasedRegion = LineOffsetUtils.convertToLineRegion((OffsetBasedRegion)region, (LineOffsetConverter)converter);
                MethodLocation methodLocation = new MethodLocation(uniformPath, region);
                MethodId methodId = methodIdLookup.getOrInsertMethodLocation(methodLocation);
                PairList methodList = this.methodInfoMap.computeIfAbsent(uniformPath.toStringAsMigrationFrontier(), path -> new PairList());
                methodList.add((Object)lineBasedRegion, (Object)methodId);
            }
        }
    }

    private Set<MethodId> aggregateMultiFileCoverageToMethods(MultiFileRangeCoverageInfo multiFileRangeCoverageInfo) {
        HashSet<MethodId> methodInfoSetMap = new HashSet<MethodId>();
        Map coverage = multiFileRangeCoverageInfo.getCoverage();
        for (String uniformPath : coverage.keySet()) {
            PairList<LineBasedRegion, MethodId> methodInfos = this.methodInfoMap.get(uniformPath);
            if (methodInfos == null) continue;
            methodInfoSetMap.addAll(CoverageUnitIntegrator.aggregateRangesToCoveredMethods(methodInfos, (CompactLines)coverage.get(uniformPath)));
        }
        return methodInfoSetMap;
    }

    private static Collection<MethodId> aggregateRangesToCoveredMethods(PairList<LineBasedRegion, MethodId> methodInfos, CompactLines coveredRanges) {
        HashSet<MethodId> methodsCoveredByTests = new HashSet<MethodId>();
        for (Pair pair : methodInfos) {
            LineBasedRegion lineBasedRegion = (LineBasedRegion)pair.getFirst();
            if (!coveredRanges.containsAny(lineBasedRegion)) continue;
            methodsCoveredByTests.add((MethodId)pair.getSecond());
        }
        return methodsCoveredByTests;
    }

    private static class MethodIdLookup {
        private final MethodIdIndex methodIdIndex;
        private final MethodIdMap methodIdMappings = new MethodIdMap(new HashMap<UniformPath, MethodLocationOffsetMapping>());

        private MethodIdLookup(MethodIdIndex methodIdIndex) {
            this.methodIdIndex = methodIdIndex;
        }

        private synchronized void persist() throws StorageException {
            this.methodIdIndex.storeUpdatedMappings(this.methodIdMappings);
        }

        private synchronized void preload(List<String> uniformPaths) throws StorageException {
            List missingUniformPaths = UniformPathCompatibilityUtil.convertCollection(uniformPaths);
            missingUniformPaths.removeAll(this.methodIdMappings.getUniformPaths());
            MethodIdMap allMappingsFor = this.methodIdIndex.getAllMappingsFor(missingUniformPaths);
            this.methodIdMappings.insertAll(allMappingsFor);
        }

        private synchronized MethodId getOrInsertMethodLocation(MethodLocation methodLocation) {
            return this.methodIdMappings.getOrInsertMethodLocation(methodLocation);
        }
    }
}

