/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.index.testimpact.ManualSapTestInfo;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Index(name="sap-tests")
public class TemporarySapTestInfoIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "sap-tests";
    private static final String KEY_SEPARATOR = "#!#";
    private final ValueIndex<ManualSapTestInfo> delegate;

    public TemporarySapTestInfoIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void removeTestInfo(String testKey) throws StorageException {
        this.delegate.removeValue(testKey);
    }

    public List<ManualSapTestInfo> getTestsToBeFetched() throws StorageException {
        return this.getAllTestsByPredicate(ManualSapTestInfo::isReadyToBeFetched);
    }

    public ManualSapTestInfo update(ManualSapTestInfo testInfoWithNewMetadata, boolean paused, boolean readyToFetch) throws StorageException {
        List<ManualSapTestInfo> entriesForUserAndProject = this.getUnfinishedTestsStartingWith(TemporarySapTestInfoIndex.makeKeyPrefix(testInfoWithNewMetadata));
        CCSMAssert.isFalse((entriesForUserAndProject.size() == 0 ? 1 : 0) != 0, (String)"Currently no SAP test execution for this user and project running.");
        CCSMAssert.isTrue((entriesForUserAndProject.size() == 1 ? 1 : 0) != 0, (String)"Inconsistent index state. Should only hold one SAP test execution per user and project.");
        ManualSapTestInfo testInfo = entriesForUserAndProject.get(0);
        testInfo.update(testInfoWithNewMetadata);
        if (readyToFetch) {
            testInfo.setAsEnded();
        }
        if (paused) {
            testInfo.pauseTimer();
        } else {
            testInfo.resumeTimer();
        }
        this.delegate.setValue(testInfo.makeKey(), (Object)testInfo);
        return testInfo;
    }

    public void removeOldAndIntegratedReports() throws StorageException {
        for (ManualSapTestInfo testEntry : this.getAllTestsByPredicate(ManualSapTestInfo::isOld)) {
            this.delegate.removeValue(testEntry.makeKey());
        }
    }

    public List<ManualSapTestInfo> getUnfinishedTestsStartingWith(String keyPrefix) throws StorageException {
        return CollectionUtils.filter((Collection)this.delegate.getEntriesStartingWith(keyPrefix).getSecondList(), ManualSapTestInfo::isUnfinished);
    }

    private List<ManualSapTestInfo> getAllTestsByPredicate(Predicate<? super ManualSapTestInfo> filter) throws StorageException {
        return CollectionUtils.filter((Collection)this.delegate.getAllEntries().getSecondList(), filter);
    }

    public static String makeKeyPrefix(ManualSapTestInfo testInfo) {
        return new StringJoiner(KEY_SEPARATOR).add(testInfo.getExecutingUser()).add(testInfo.getProjectId().toString()).toString();
    }

    public static String makeKey(ManualSapTestInfo testInfo) {
        return new StringJoiner(KEY_SEPARATOR).add(TemporarySapTestInfoIndex.makeKeyPrefix(testInfo)).add(Long.toString(testInfo.getStartTimestamp())).toString();
    }

    public void setTestInfo(ManualSapTestInfo sapTestInfo) throws StorageException {
        this.delegate.setValue(sapTestInfo.makeKey(), (Object)sapTestInfo);
    }

    public @Nullable ManualSapTestInfo getTestInfo(String testKey) throws StorageException {
        return (ManualSapTestInfo)this.delegate.getValue(testKey);
    }

    public PairList<String, ManualSapTestInfo> getTestInfosWithKeyPrefix(String keyPrefix) throws StorageException {
        return this.delegate.getEntriesStartingWith(keyPrefix);
    }

    public void removeValues(List<String> testKeys) throws StorageException {
        this.delegate.removeValues(testKeys);
    }

    public UnmodifiableList<ManualSapTestInfo> getAllTestInfos() throws StorageException {
        return this.delegate.getAllEntries().getSecondList();
    }
}

