/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tests.extractor;

import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.core.xpath.DocumentRootShallowEntity;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocationUtils;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class TokenElementTransformContext {
    private final TokenElementInfo tokenElementInfo;
    private final StringOffsetTransformer offsetTransformer;
    private final LineOffsetConverter rawLineOffsetConverter;

    public TokenElementTransformContext(TokenElementInfo tokenElementInfo) {
        this.tokenElementInfo = tokenElementInfo;
        this.offsetTransformer = new StringOffsetTransformer((List)tokenElementInfo.getFilterDeletions());
        this.rawLineOffsetConverter = new LineOffsetConverter(tokenElementInfo.getText());
    }

    public TokenElementInfo getTokenElementInfo() {
        return this.tokenElementInfo;
    }

    public String getUniformPath() {
        return this.tokenElementInfo.getUniformPath();
    }

    public @NonNull UnmodifiableList<IToken> getTokens() {
        return this.tokenElementInfo.getTokens();
    }

    public List<IToken> getPreprocessedTokens() {
        return this.tokenElementInfo.getPreprocessedTokens();
    }

    public Optional<ShallowEntity> getRawShallowEntityAtRawStartLine(int rawStartLine, Predicate<ShallowEntity> filter) {
        return ShallowEntityTraversalUtils.selectEntities(this.getRawShallowEntities(), entity -> entity.getStartLine() == rawStartLine).stream().filter(filter).findFirst();
    }

    public int getRawLineFromOffset(int nonRawOffset) {
        int rawOffset = this.offsetTransformer.getUnfilteredOffset(nonRawOffset);
        return this.rawLineOffsetConverter.getLine(rawOffset);
    }

    public int getNonRawOffset(int rawOffset) {
        return this.offsetTransformer.getFilteredOffset(rawOffset);
    }

    public int getRawOffset(int nonRawOffset) {
        return this.offsetTransformer.getUnfilteredOffset(nonRawOffset);
    }

    public @NonNull TextRegionLocation createLocationForRawShallowEntity(ShallowEntity rawEntity) {
        int startOffset = rawEntity.getStartOffset();
        int endOffset = rawEntity.getEndOffset();
        return new TextRegionLocation(this.getUniformPath(), startOffset, endOffset, rawEntity.getStartLine(), rawEntity.getEndLine());
    }

    public @NonNull TextRegionLocation createLocationForNonRawShallowEntity(ShallowEntity nonRawEntity) {
        int startOffset = nonRawEntity.getStartOffset();
        int endOffset = nonRawEntity.getEndOffset();
        return TextRegionLocationUtils.createTextRegionLocationForFilteredOffsets((String)this.getUniformPath(), (int)startOffset, (int)endOffset, (StringOffsetTransformer)this.offsetTransformer, (LineOffsetConverter)this.rawLineOffsetConverter);
    }

    public TextRegionLocation createLocationWithFilteredStartOffset(int nonRawStartOffset, TextRegionLocation location) {
        int rawStartOffset = this.getRawOffset(nonRawStartOffset);
        int rawStartLine = this.getRawLineFromOffset(nonRawStartOffset);
        return new TextRegionLocation(location.getUniformPath(), rawStartOffset, location.getRawEndOffset(), rawStartLine, location.getRawEndLine());
    }

    public UnmodifiableList<ShallowEntity> getShallowEntitiesWithPreprocessorTokens() {
        UnmodifiableList<ShallowEntity> shallowEntities = this.tokenElementInfo.getShallowEntitiesWithPreprocessorTokens();
        CCSMAssert.isNotNull(shallowEntities, (String)"Expected only token elements for which we support shallow parsing.");
        DocumentRootShallowEntity.wrapWithRootIfNecessary(shallowEntities, (String)this.getUniformPath());
        return shallowEntities;
    }

    public List<ShallowEntity> getRawShallowEntities() {
        List<ShallowEntity> shallowEntities = this.tokenElementInfo.getRawShallowEntities();
        CCSMAssert.isNotNull(shallowEntities, (String)"Expected only token elements for which we support shallow parsing.");
        DocumentRootShallowEntity.wrapWithRootIfNecessary(shallowEntities, (String)this.getUniformPath());
        return shallowEntities;
    }
}

