/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.blacklisting.BranchAgnosticFindingBlacklistIndex;
import com.teamscale.index.tracking.index.FindingIdentificationIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class FindingIdentificationIndexCleanupTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DRY_RUN = "dry-run";

    public void execute() throws Exception {
        LOGGER.warn("Running finding identification index cleanup for project {}", (Object)this.getContext().getProjectId());
        boolean dryRun = DRY_RUN.equals(this.jobDescriptor.getParameter());
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.jobDescriptor.getInternalProjectId());
        FindingIdentificationIndexCleanupTrigger.runCleanup((ProjectStorageSystem)projectStorageSystem, dryRun);
    }

    @VisibleForTesting
    static void runCleanup(ProjectStorageSystem projectStorageSystem, boolean dryRun) throws StorageException {
        Set<ByteArrayWrapper> allFindingIds = FindingIdentificationIndexCleanupTrigger.extractAllFindingIdsFromTrackedFindingByIdIndex(projectStorageSystem);
        allFindingIds.addAll(FindingIdentificationIndexCleanupTrigger.extractAllFindingIdsFromBlacklistIndex(projectStorageSystem));
        ArrayList<byte[]> keysToDelete = new ArrayList<byte[]>();
        PairList replacementValues = new PairList();
        LongAdder criterionBytesRemoved = new LongAdder();
        LongAdder minHashBytesRemoved = new LongAdder();
        LongAdder retainedSize = new LongAdder();
        FindingIdentificationIndex findingIdentificationIndex = (FindingIdentificationIndex)projectStorageSystem.openProjectIndex(FindingIdentificationIndex.class, null);
        FindingIdentificationIndexCleanupTrigger.determineReplacementsAndDeletions(findingIdentificationIndex, allFindingIds, keysToDelete, criterionBytesRemoved, (PairList<byte[], Set<ByteArrayWrapper>>)replacementValues, retainedSize, minHashBytesRemoved);
        FindingIdentificationIndexCleanupTrigger.logAndApplyResults(keysToDelete, (PairList<byte[], Set<ByteArrayWrapper>>)replacementValues, criterionBytesRemoved, minHashBytesRemoved, retainedSize, findingIdentificationIndex, dryRun);
    }

    private static @NonNull Set<ByteArrayWrapper> extractAllFindingIdsFromTrackedFindingByIdIndex(ProjectStorageSystem projectStorageSystem) throws StorageException {
        IBranchingLayer findingsByIdStorageLayer = projectStorageSystem.openBranchingLayer(TrackedFindingsByIdIndex.class);
        HashSet<ByteArrayWrapper> allFindingIds = new HashSet<ByteArrayWrapper>();
        findingsByIdStorageLayer.scanAllKeysInAllCommits(key -> {
            Set set = allFindingIds;
            synchronized (set) {
                allFindingIds.add(new ByteArrayWrapper(StringUtils.decodeFromHex((String)StringUtils.bytesToString((byte[])key))));
            }
        });
        List nonFindingIds = CollectionUtils.filter(allFindingIds, id -> id.getLength() != 16);
        if (!nonFindingIds.isEmpty()) {
            throw new AssertionError((Object)("Stopped execution as non-finding ids were extracted from the code (which should not be possible). Samples: \n" + nonFindingIds.stream().limit(10L).map(id -> id.toString() + " (" + StringUtils.bytesToString((byte[])id.getBytes()) + ")").collect(Collectors.joining("\n"))));
        }
        LOGGER.warn("Found " + allFindingIds.size() + " finding ids in the index.");
        return allFindingIds;
    }

    private static @NonNull Set<ByteArrayWrapper> extractAllFindingIdsFromBlacklistIndex(ProjectStorageSystem projectStorageSystem) throws StorageException {
        BranchAgnosticFindingBlacklistIndex blacklistIndex = (BranchAgnosticFindingBlacklistIndex)projectStorageSystem.openProjectIndex(BranchAgnosticFindingBlacklistIndex.class, null);
        return CollectionUtils.mapToSet(blacklistIndex.getAllExistingBlacklistInfos(), info -> new ByteArrayWrapper(StringUtils.decodeFromHex((String)info.getFindingId())));
    }

    private static void determineReplacementsAndDeletions(FindingIdentificationIndex findingIdentificationIndex, Set<ByteArrayWrapper> allFindingIds, List<byte[]> keysToDelete, LongAdder criterionBytesRemoved, PairList<byte[], Set<ByteArrayWrapper>> replacementValues, LongAdder retainedSize, LongAdder minHashBytesRemoved) throws StorageException {
        findingIdentificationIndex.listContents((criterionKey, findingIds) -> {
            Set filtered = CollectionUtils.filterToSet((Collection)findingIds, allFindingIds::contains);
            if (filtered.isEmpty()) {
                List list = keysToDelete;
                synchronized (list) {
                    keysToDelete.add((byte[])criterionKey);
                }
                criterionBytesRemoved.add((long)((byte[])criterionKey).length + (long)findingIds.size() * 16L);
            } else if (filtered.size() < findingIds.size()) {
                PairList pairList = replacementValues;
                synchronized (pairList) {
                    replacementValues.add(criterionKey, (Object)filtered);
                }
                criterionBytesRemoved.add((long)(findingIds.size() - filtered.size()) * 16L);
                retainedSize.add((long)((byte[])criterionKey).length + (long)filtered.size() * 16L);
            } else {
                retainedSize.add((long)((byte[])criterionKey).length + (long)filtered.size() * 16L);
            }
        }, (findingIdKey, minHash) -> {
            if (!allFindingIds.contains(findingIdKey)) {
                List list = keysToDelete;
                synchronized (list) {
                    keysToDelete.add(StringUtils.stringToBytes((String)findingIdKey.toString()));
                }
                minHashBytesRemoved.add(findingIdKey.getLength() + ((byte[])minHash).length);
            } else {
                retainedSize.add(findingIdKey.getLength() + ((byte[])minHash).length);
            }
        });
    }

    private static void logAndApplyResults(List<byte[]> keysToDelete, PairList<byte[], Set<ByteArrayWrapper>> replacementValues, LongAdder criterionBytesRemoved, LongAdder minHashBytesRemoved, LongAdder retainedSize, FindingIdentificationIndex findingIdentificationIndex, boolean dryRun) throws StorageException {
        LOGGER.warn("Found " + keysToDelete.size() + " keys that could be deleted from the finding identification index and " + replacementValues.size() + " keys that can be reduced in size.");
        LOGGER.warn("Expected size savings: " + String.valueOf(criterionBytesRemoved) + " bytes in criterion keys/values and " + String.valueOf(minHashBytesRemoved) + " bytes in min hash keys/values.");
        LOGGER.warn("Retained key/value size: " + String.valueOf(retainedSize) + " bytes");
        if (dryRun) {
            LOGGER.warn("This is just a dry run, so nothing is applied.");
        } else {
            findingIdentificationIndex.persistCleanupResults(replacementValues, keysToDelete);
        }
    }
}

