/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.utils.TimestampedInteraction;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.LastChangeTrackingValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

final class UserRecentInteractionIndex
implements IUtilityIndex {
    private static final int DEFAULT_MAX_STORED_ITEMS_PER_USER = 15;
    private final int maxStoredItemsPerUser;
    private final LastChangeTrackingValueIndex<LinkedList<TimestampedInteraction>> delegate;

    public UserRecentInteractionIndex(IStore store, Integer numItems) {
        this.delegate = new LastChangeTrackingValueIndex(store);
        this.maxStoredItemsPerUser = numItems;
    }

    public UserRecentInteractionIndex(IStore store) {
        this(store, 15);
    }

    public void registerItemInteraction(String userName, TimestampedInteraction itemTimestampedInteraction) throws StorageException {
        this.delegate.runLocked("update", () -> this.doRegisterItemInteraction(userName, itemTimestampedInteraction));
    }

    private void doRegisterItemInteraction(String userName, TimestampedInteraction itemTimestampedInteraction) throws StorageException {
        LinkedList<TimestampedInteraction> recentItems = this.getRecentItemsUnlocked(userName);
        int indexToInsert = UserRecentInteractionIndex.getIndexToInsert(itemTimestampedInteraction, recentItems);
        if (indexToInsert == -1) {
            return;
        }
        recentItems.add(indexToInsert, itemTimestampedInteraction);
        recentItems.removeIf(item -> item.identifier().equals(itemTimestampedInteraction.identifier()) && itemTimestampedInteraction != item);
        while (recentItems.size() > this.maxStoredItemsPerUser) {
            recentItems.removeLast();
        }
        this.delegate.setValue(userName, recentItems);
    }

    public void registerItemInteraction(String userName, String item) throws StorageException {
        this.registerItemInteraction(userName, new TimestampedInteraction(Long.valueOf(System.currentTimeMillis()), item));
    }

    private static int getIndexToInsert(TimestampedInteraction itemTimestampedInteraction, LinkedList<TimestampedInteraction> recentItems) {
        long itemToInsertTimestamp = itemTimestampedInteraction.timestamp();
        String itemToInsertIdentifier = itemTimestampedInteraction.identifier();
        for (int i = 0; i < recentItems.size(); ++i) {
            TimestampedInteraction currentItem = recentItems.get(i);
            if (itemToInsertIdentifier.equals(currentItem.identifier()) && currentItem.timestamp() > itemToInsertTimestamp) {
                return -1;
            }
            if (itemToInsertTimestamp < currentItem.timestamp()) continue;
            return i;
        }
        return recentItems.size();
    }

    public void removeItemInteraction(String userName, String identifier) throws StorageException {
        this.delegate.runLocked(userName, () -> {
            LinkedList<TimestampedInteraction> recentItems = this.getRecentItemsUnlocked(userName);
            recentItems.removeIf(timestampedInteraction -> identifier.equals(timestampedInteraction.identifier()));
            this.delegate.setValue(userName, recentItems);
        });
    }

    public List<TimestampedInteraction> getRecentItemsWithTimestamps(String userName) throws StorageException {
        return (List)this.delegate.computeLocked(userName, () -> this.getRecentItemsUnlocked(userName));
    }

    public List<String> getRecentItems(String userName) throws StorageException {
        return this.getRecentItemsWithTimestamps(userName).stream().map(TimestampedInteraction::identifier).toList();
    }

    private @NonNull LinkedList<TimestampedInteraction> getRecentItemsUnlocked(String userName) throws StorageException {
        return Optional.ofNullable((LinkedList)this.delegate.getValue(userName)).orElse(new LinkedList());
    }

    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.delegate.getLastChangeTimestamp();
    }

    public IStore getWrappedStore() {
        return this.delegate.getWrappedStore();
    }
}

