/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.function.SupplierWithException;

public class StorageCacheProvider {
    private static final String CACHE_INVALIDATION_SEND_CHANNEL = "cache-provider-invalidation";
    private final Map<Class<? extends StorageCacheBase>, SupplierWithException<StorageCacheBase, ReflectiveOperationException>> cacheFactoriesByClass = new HashMap<Class<? extends StorageCacheBase>, SupplierWithException<StorageCacheBase, ReflectiveOperationException>>();
    private final TwoDimHashMap<String, Class<? extends StorageCacheBase>, StorageCacheBase> cachesByStorageSystemAndCacheClass = new TwoDimHashMap();
    private final IMessageBroker messageBroker;

    StorageCacheProvider(List<SupplierWithException<StorageCacheBase, ReflectiveOperationException>> cacheFactories, IMessageBroker messageBroker) {
        cacheFactories.forEach(factory -> {
            try {
                this.cacheFactoriesByClass.put(((StorageCacheBase)factory.get()).getClass(), (SupplierWithException<StorageCacheBase, ReflectiveOperationException>)factory);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
        this.messageBroker = messageBroker;
    }

    public synchronized void invalidateCaches() {
        this.cachesByStorageSystemAndCacheClass.getFirstKeys().forEach(this::invalidateCachesForStorageSystem);
    }

    public StorageSystemCacheProvider getCacheProvider(String storageSystemName) {
        return new StorageSystemCacheProvider(storageSystemName);
    }

    public static String buildMessageChannelId(String storageSystemName, Class<? extends StorageCacheBase> cacheClass) {
        return "cache-provider-invalidation/" + storageSystemName + "/" + cacheClass.getName();
    }

    private synchronized void invalidateCachesForStorageSystem(String storageSystemName) {
        Optional.ofNullable(this.cachesByStorageSystemAndCacheClass.getSecondMap((Object)storageSystemName)).ifPresent(cachesByClass -> cachesByClass.forEach((cacheClass, cache) -> {
            cache.invalidateThreadSafe();
            this.messageBroker.sendMessage(StorageCacheProvider.buildMessageChannelId(storageSystemName, cacheClass), "Invalidation of all caches for storage system: " + storageSystemName);
        }));
    }

    public class StorageSystemCacheProvider {
        private final String storageSystemName;

        private StorageSystemCacheProvider(String storageSystemName) {
            this.storageSystemName = storageSystemName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends StorageCacheBase> T getCache(Class<T> cacheClass) {
            StorageCacheProvider storageCacheProvider = StorageCacheProvider.this;
            synchronized (storageCacheProvider) {
                StorageCacheBase cache = (StorageCacheBase)StorageCacheProvider.this.cachesByStorageSystemAndCacheClass.getValue((Object)this.storageSystemName, cacheClass);
                if (cache == null) {
                    try {
                        cache = (StorageCacheBase)StorageCacheProvider.this.cacheFactoriesByClass.get(cacheClass).get();
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException("Error creating cache " + String.valueOf(cacheClass), e);
                    }
                    this.bindMessageBroker(cache);
                    StorageCacheProvider.this.cachesByStorageSystemAndCacheClass.putValue((Object)this.storageSystemName, cacheClass, (Object)cache);
                }
                return (T)((StorageCacheBase)CCSMAssert.checkedCast((Object)cache, cacheClass));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bindMessageBroker(StorageCacheBase cache) {
            StorageCacheProvider storageCacheProvider = StorageCacheProvider.this;
            synchronized (storageCacheProvider) {
                StorageCacheProvider.this.messageBroker.registerListener(StorageCacheProvider.buildMessageChannelId(this.storageSystemName, cache.getClass()), message -> cache.invalidateThreadSafe());
            }
        }

        public <T extends StorageCacheBase> SynchronizedCacheAccess<T> getCacheAccess(Class<T> cacheClass) {
            return new SynchronizedCacheAccess<T>(this.getCache(cacheClass), this.storageSystemName, StorageCacheProvider.this.messageBroker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateCaches() {
            StorageCacheProvider storageCacheProvider = StorageCacheProvider.this;
            synchronized (storageCacheProvider) {
                StorageCacheProvider.this.invalidateCachesForStorageSystem(this.storageSystemName);
            }
        }
    }
}

