/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.conqat.engine.core.configuration.ConfigurationException;
import org.jetbrains.annotations.VisibleForTesting;

public class DatabaseTypeChecker {
    @VisibleForTesting
    static final String DATABASE_TYPE_FILE_NAME = "TEAMSCALE.DBNAME";

    public static void checkDatabaseType(File storageDirectory, String expectedDatabaseType) throws ConfigurationException {
        try {
            if (!storageDirectory.exists()) {
                return;
            }
            Path keyFile = storageDirectory.toPath().resolve(DATABASE_TYPE_FILE_NAME);
            if (Files.exists(keyFile, new LinkOption[0])) {
                DatabaseTypeChecker.checkDatabaseTypeMatchesExpected(storageDirectory, expectedDatabaseType, keyFile);
            } else {
                Files.writeString(keyFile, (CharSequence)expectedDatabaseType, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("IO Error occurred attempting to check the database matches the configuration", (Throwable)e);
        }
    }

    private static void checkDatabaseTypeMatchesExpected(File storageDirectory, String expectedDatabaseType, Path keyFile) throws IOException, ConfigurationException {
        String read = Files.readString(keyFile);
        if (!read.trim().equalsIgnoreCase(expectedDatabaseType.trim())) {
            throw new ConfigurationException("The configuration specifies a " + expectedDatabaseType + " database, but there is a " + read + " one at " + String.valueOf(storageDirectory));
        }
    }
}

