/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PartitionedIndexBase<T extends Serializable>
extends PartitionIndexBase {
    protected PartitionedIndexBase(IStore store, boolean autoAbbreviate) {
        super(store, autoAbbreviate);
    }

    protected void setValues(String partition, PairList<String, T> uniformPathsAndValues) throws StorageException {
        this.addPartition(partition);
        PairList keysValues = new PairList();
        for (int i = 0; i < uniformPathsAndValues.size(); ++i) {
            String key = PartitionedIndexBase.makeKey(partition, (String)uniformPathsAndValues.getFirst(i));
            byte[] value = StorageUtils.serialize((Serializable)uniformPathsAndValues.getSecond(i));
            keysValues.add((Object)key, (Object)value);
        }
        this.store.putWithStrings((PairList<String, byte[]>)keysValues);
    }

    protected void setValues(PairList<PartitionAndPath, T> uniformPathsAndValues) throws StorageException {
        Set partitions = CollectionUtils.mapToSet((Collection)uniformPathsAndValues.getFirstList(), PartitionAndPath::getPartition);
        this.addPartitions(partitions);
        PairList keysValues = uniformPathsAndValues.mapWithException(key -> PartitionedIndexBase.makeKey(key.getPartition(), key.getUniformPath()), StorageUtils::serialize);
        this.store.putWithStrings((PairList<String, byte[]>)keysValues);
    }

    protected void setValues(Map<String, Map<String, T>> uniformPathsAndValuesWithPartition) throws StorageException {
        PairList keysValues = new PairList();
        HashSet<String> partitions = new HashSet<String>();
        for (Map.Entry<String, Map<String, T>> uniformPathsAndValuesPerPartition : uniformPathsAndValuesWithPartition.entrySet()) {
            String partition = uniformPathsAndValuesPerPartition.getKey();
            Map<String, T> uniformPathsAndValues = uniformPathsAndValuesPerPartition.getValue();
            for (Map.Entry<String, T> uniformPathAndValue : uniformPathsAndValues.entrySet()) {
                String key = PartitionedIndexBase.makeKey(partition, uniformPathAndValue.getKey());
                byte[] value = StorageUtils.serialize((Serializable)uniformPathAndValue.getValue());
                keysValues.add((Object)key, (Object)value);
            }
            partitions.add(partition);
        }
        this.addPartitions(partitions);
        this.store.putWithStrings((PairList<String, byte[]>)keysValues);
    }

    protected void setOrMergeValues(Map<String, Map<String, T>> uniformPathsAndValuesWithPartition, BinaryOperator<T> mergeFunction) throws StorageException {
        CollectionUtils.forEach(uniformPathsAndValuesWithPartition.entrySet(), entry -> this.setOrMergeValues((String)entry.getKey(), (Map)entry.getValue(), mergeFunction));
    }

    protected void setOrMergeValues(String partition, Map<String, T> pathsAndValues, BinaryOperator<T> mergeFunction) throws StorageException {
        List<String> paths = List.copyOf(pathsAndValues.keySet());
        List<T> existingValuesForPaths = this.getValues(partition, paths);
        HashMap<String, Serializable> mergedValues = new HashMap<String, Serializable>(pathsAndValues.size());
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            Serializable oldValue = (Serializable)existingValuesForPaths.get(i);
            if (mergedValues.containsKey(path)) {
                oldValue = (Serializable)mergedValues.get(path);
            }
            Serializable valueToAdd = (Serializable)pathsAndValues.get(path);
            if (oldValue != null) {
                valueToAdd = (Serializable)mergeFunction.apply(oldValue, valueToAdd);
            }
            mergedValues.put(path, valueToAdd);
        }
        this.setValues(Map.of(partition, mergedValues));
    }

    protected T getValue(String partition, String uniformPath) throws StorageException {
        return StorageUtils.deserialize(this.store.getWithString(PartitionedIndexBase.makeKey(partition, uniformPath)));
    }

    protected T getValue(String partition, UniformPath uniformPath) throws StorageException {
        return StorageUtils.deserialize(this.store.getWithString(PartitionedIndexBase.makeKey(partition, uniformPath)));
    }

    protected List<T> getValues(String partition, List<String> uniformPaths) throws StorageException {
        return StorageUtils.deserializeValues(this.store.getWithStrings(PartitionedIndexBase.makeKeys(partition, uniformPaths)));
    }

    protected List<T> getValuesForUniformPaths(String partition, List<UniformPath> uniformPaths) throws StorageException {
        return StorageUtils.deserializeValues(this.store.getWithStrings(PartitionedIndexBase.makeKeysForUniformPaths(partition, uniformPaths)));
    }

    protected Map<String, Map<String, T>> getValuesForUniformPaths(List<String> partitions, List<UniformPath> uniformPaths) throws StorageException {
        return this.getValues(partitions, CollectionUtils.map(uniformPaths, UniformPath::toString));
    }

    protected Map<String, Map<String, T>> getValues(Collection<String> partitions, Collection<String> uniformPaths) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (String partition : partitions) {
            for (String uniformPath : uniformPaths) {
                keys.add(PartitionedIndexBase.makeKey(partition, uniformPath));
            }
        }
        List<byte[]> rawData = this.store.getWithStrings(keys);
        CCSMAssert.isTrue((rawData.size() == partitions.size() * uniformPaths.size() ? 1 : 0) != 0, (String)"Expected same number for values returned from store");
        HashMap<String, Map<String, T>> partitionsToPathAndValues = new HashMap<String, Map<String, T>>();
        int i = 0;
        for (String partition : partitions) {
            if (!partitionsToPathAndValues.containsKey(partition)) {
                partitionsToPathAndValues.put(partition, new HashMap());
            }
            for (String uniformPath : uniformPaths) {
                Object value = StorageUtils.deserialize(rawData.get(i));
                if (value != null) {
                    ((Map)partitionsToPathAndValues.get(partition)).put(uniformPath, value);
                }
                ++i;
            }
        }
        return partitionsToPathAndValues;
    }

    protected List<T> getValues(List<String> partitions, UniformPath uniformPath) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (String partition : partitions) {
            keys.add(PartitionedIndexBase.makeKey(partition, uniformPath));
        }
        return StorageUtils.deserializeValues(this.store.getWithStrings(keys));
    }

    public List<T> getValues(Collection<PartitionAndPath> partitionAndPaths) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (PartitionAndPath partition : partitionAndPaths) {
            keys.add(PartitionedIndexBase.makeKey(partition.getPartition(), partition.getUniformPath()));
        }
        return StorageUtils.deserializeValues(this.store.getWithStrings(keys));
    }

    private Map<UniformPath, T> getValuesByUniformPath(String partition) throws StorageException {
        HashMap result = new HashMap();
        for (Pair keyAndValue : this.store.getEntriesStartingWith(PartitionedIndexBase.makePartitionKeyPrefix(partition))) {
            String keyAsString = StringUtils.bytesToString((byte[])((byte[])keyAndValue.getFirst()));
            UniformPath uniformPath = (UniformPath)PartitionedIndexBase.splitKeyAsUniformPath(keyAsString).getSecond();
            result.put(uniformPath, StorageUtils.deserialize((byte[])keyAndValue.getSecond()));
        }
        return result;
    }

    public void setValue(String partition, String uniformPath, T value) throws StorageException {
        this.addPartition(partition);
        this.store.putWithString(PartitionedIndexBase.makeKey(partition, uniformPath), StorageUtils.serialize(value));
    }

    protected void removeValues(String partition, List<String> uniformPaths) throws StorageException {
        this.store.removeWithStrings(PartitionedIndexBase.makeKeys(partition, uniformPaths));
    }

    @VisibleForTesting
    public List<Pair<String, Map<UniformPath, T>>> getAllValuesDebug() throws StorageException {
        ArrayList<Pair<String, Map<UniformPath, T>>> result = new ArrayList<Pair<String, Map<UniformPath, T>>>();
        for (String partition : this.getPartitions()) {
            result.add(new Pair((Object)partition, this.getValuesByUniformPath(partition)));
        }
        return result;
    }
}

