/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.collections;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class CounterSetSerializer<T>
implements ISerializer<CounterSet<T>, byte[]> {
    private final FunctionWithException<List<T>, List<Integer>, StorageException> elementAbbreviator;
    private final FunctionWithException<List<Integer>, List<T>, StorageException> elementUnabbreviator;

    public CounterSetSerializer(FunctionWithException<List<T>, List<Integer>, StorageException> elementAbbreviator, FunctionWithException<List<Integer>, List<T>, StorageException> elementUnabbreviator) {
        this.elementAbbreviator = elementAbbreviator;
        this.elementUnabbreviator = elementUnabbreviator;
    }

    @Override
    public byte @NonNull [] serialize(@NonNull CounterSet<T> value) throws StorageException {
        return CounterSetSerializer.serializeCounterSet(value, this.elementAbbreviator);
    }

    @Override
    public @NonNull CounterSet<T> deserialize(byte @NonNull [] value) throws StorageException {
        return CounterSetSerializer.deserializeCounterSet(value, this.elementUnabbreviator);
    }

    public static byte[] serializeCounterSet(CounterSet<Integer> counterSet) throws StorageException {
        return CounterSetSerializer.serializeCounterSet(counterSet, e -> e);
    }

    private static <E> byte[] serializeCounterSet(CounterSet<E> counterSet, FunctionWithException<List<E>, List<Integer>, StorageException> elementAbbreviator) throws StorageException {
        List keys = List.copyOf(counterSet.getKeys());
        byte[] data = new byte[8 + keys.size() * 4 * 2];
        List keysAbbreviated = (List)elementAbbreviator.apply(keys);
        int offset = 0;
        ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)counterSet.getTotal());
        ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(offset += 4), (int)keys.size());
        offset += 4;
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            Integer keyAbbreviated = (Integer)keysAbbreviated.get(i);
            int count = counterSet.getValue(key);
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)offset, (int)keyAbbreviated);
            ByteArrayUtils.putIntIntoByteArray((byte[])data, (int)(offset += 4), (int)count);
            offset += 4;
        }
        return data;
    }

    public static int deserializeCounterSetSize(byte[] data) {
        if (data == null || data.length == 0) {
            return 0;
        }
        return ByteArrayUtils.getIntFromByteArray((byte[])data, (int)0);
    }

    public static <T> CounterSet<T> deserializeCounterSet(byte[] data, FunctionWithException<List<Integer>, List<T>, StorageException> elementUnabbreviator) throws StorageException {
        if (data == null || data.length == 0) {
            return CounterSet.empty();
        }
        int dataPairs = (data.length - 8) / 8;
        int offset = 8;
        PairList abbreviated = new PairList();
        for (int i = 0; i < dataPairs; ++i) {
            Integer abbreviatedKey = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)offset);
            int count = ByteArrayUtils.getIntFromByteArray((byte[])data, (int)(offset += 4));
            offset += 4;
            abbreviated.add((Object)abbreviatedKey, (Object)count);
        }
        CounterSet result = new CounterSet();
        List unabbreviatedKeys = (List)elementUnabbreviator.apply((Object)abbreviated.extractFirstList());
        for (int i = 0; i < unabbreviatedKeys.size(); ++i) {
            result.inc(unabbreviatedKeys.get(i), ((Integer)abbreviated.getSecond(i)).intValue());
        }
        return result;
    }
}

