/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CompactFormatBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

public class CompactCommitLayeringDataLayout
implements ICommitLayeringDataLayout {
    private static final byte[] COMMIT_INFO_KEY_PREFIX = new byte[]{-16};
    private static final byte[] BRANCH_HEAD_KEY_PREFIX = new byte[]{-15};
    private static final byte[] DATA_KEY_PREFIX = new byte[]{-14};
    private static final byte[] ABBREVIATION_COUNTER_KEY = new byte[]{-13};

    @Override
    public byte[] createCommitEntryKey(byte[] commitBinaryName, byte @Nullable [] key) {
        if (key == null) {
            return commitBinaryName;
        }
        return ByteArrayUtils.concat((byte[][])new byte[][]{commitBinaryName, key});
    }

    @Override
    public byte[] extractUnderlyingKeyFromCommitEntryKey(byte[] commitEntryKey) {
        if (commitEntryKey.length < 4) {
            throw new AssertionError((Object)("Passed a non-commit entry key to this method! Key too short. Offending key: " + StringUtils.encodeAsHex((byte[])commitEntryKey)));
        }
        return Arrays.copyOfRange(commitEntryKey, 4, commitEntryKey.length);
    }

    @Override
    public byte[] createDataKey(byte[] referenceHash) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{DATA_KEY_PREFIX, referenceHash});
    }

    @Override
    public byte[] extractReferenceHash(byte[] dataKey) {
        return Arrays.copyOfRange(dataKey, DATA_KEY_PREFIX.length, dataKey.length);
    }

    @Override
    public int determineKeyOffset(byte[] commitName) {
        return 4;
    }

    @Override
    public byte[] createCommitInfoKey(byte[] commitName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{COMMIT_INFO_KEY_PREFIX, commitName});
    }

    @Override
    public byte[] extractCommitNameFromCommitInfoKey(byte[] commitKey) {
        return Arrays.copyOfRange(commitKey, COMMIT_INFO_KEY_PREFIX.length, commitKey.length);
    }

    @Override
    public byte[] createBranchHeadKey(String branchName) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{BRANCH_HEAD_KEY_PREFIX, StringUtils.stringToBytes((String)branchName)});
    }

    @Override
    public String extractBranchNameFromHeadKey(byte[] headKey) {
        return StringUtils.bytesToString((byte[])Arrays.copyOfRange(headKey, BRANCH_HEAD_KEY_PREFIX.length, headKey.length));
    }

    @Override
    public IBranchCommitInfo deserializeCommitInfo(byte[] bytes) throws StorageException {
        CompactFormatBranchCommitInfo compactFormatBranchCommitInfo;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            byte[] commitName = CompactCommitLayeringDataLayout.readNullable(bis);
            byte[] commitNameForKeys = CompactCommitLayeringDataLayout.readAbbreviated(bis);
            byte[] parentCommitName = CompactCommitLayeringDataLayout.readNullable(bis);
            byte[] deltaPredecessorCommitName = CompactCommitLayeringDataLayout.readNullable(bis);
            byte[][] allDeltaPredecessorCommitNamesForDataKeys = null;
            int count = ByteArrayUtils.byteArrayToInt((byte[])CompactCommitLayeringDataLayout.readAbbreviated(bis));
            if (count > 0) {
                allDeltaPredecessorCommitNamesForDataKeys = new byte[count][];
                for (int i = 0; i < count; ++i) {
                    allDeltaPredecessorCommitNamesForDataKeys[i] = CompactCommitLayeringDataLayout.readAbbreviated(bis);
                }
            }
            int depth = ByteArrayUtils.byteArrayToInt((byte[])CompactCommitLayeringDataLayout.readAbbreviated(bis));
            ECommitStatus status = ECommitStatus.values()[bis.read()];
            compactFormatBranchCommitInfo = new CompactFormatBranchCommitInfo(commitName, commitNameForKeys, parentCommitName, deltaPredecessorCommitName, allDeltaPredecessorCommitNamesForDataKeys, depth, status);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
        bis.close();
        return compactFormatBranchCommitInfo;
    }

    private static byte[] readAbbreviated(ByteArrayInputStream bis) throws IOException {
        byte[] data = new byte[4];
        FileSystemUtils.safeRead((InputStream)bis, (byte[])data);
        return data;
    }

    private static byte[] readNullable(ByteArrayInputStream bis) throws IOException {
        int count = ByteArrayUtils.byteArrayToInt((byte[])CompactCommitLayeringDataLayout.readAbbreviated(bis));
        if (count == 0) {
            return null;
        }
        byte[] data = new byte[count];
        FileSystemUtils.safeRead((InputStream)bis, (byte[])data);
        return data;
    }

    @Override
    public IBranchCommitInfo createInitialBranchCommitInfo(byte[] commitName, IStore underlyingStore) throws StorageException {
        return new CompactFormatBranchCommitInfo(commitName, CompactCommitLayeringDataLayout.generateCommitName(underlyingStore), null, null, null, 1, ECommitStatus.WRITEABLE);
    }

    @Override
    public IBranchCommitInfo createParentedBranchCommitInfo(byte[] commitName, IBranchCommitInfo parentCommit, byte[] deltaPredecessorCommitName, List<byte[]> deltaHierarchyCommitNamesForKeys, IStore underlyingStore) throws StorageException {
        byte[][] deltaHierarchyCommitNames = (byte[][])CollectionUtils.toArray(deltaHierarchyCommitNamesForKeys, byte[].class);
        return new CompactFormatBranchCommitInfo(commitName, CompactCommitLayeringDataLayout.generateCommitName(underlyingStore), parentCommit.getCommitName(), deltaPredecessorCommitName, deltaHierarchyCommitNames, parentCommit.getDepth() + 1, ECommitStatus.WRITEABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] generateCommitName(IStore underlyingStore) throws StorageException {
        Lock lock = underlyingStore.obtainLock("commit-abbreviator");
        lock.lock();
        try {
            int counter;
            byte[] value = underlyingStore.get(ABBREVIATION_COUNTER_KEY);
            if (value == null) {
                counter = 1;
            } else {
                counter = ByteArrayUtils.byteArrayToInt((byte[])value) + 1;
                if (counter < 0) {
                    throw new AssertionError((Object)"We had an integer overflow while generating a new commit name! This should not happen during normal operation.");
                }
            }
            byte[] newValue = ByteArrayUtils.intToByteArray((int)counter);
            underlyingStore.put(ABBREVIATION_COUNTER_KEY, newValue);
            byte[] byArray = newValue;
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void scanAllCommitEntries(IStore store, IKeyValueCallback callback, boolean includeValues) throws StorageException {
        if (includeValues) {
            store.scan(new byte[0], COMMIT_INFO_KEY_PREFIX, callback);
        } else {
            store.scanKeys(null, COMMIT_INFO_KEY_PREFIX, callback);
        }
    }
}

