/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.monitoring;

import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.ConcurrentStatsCounter;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.metrics.Counter;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PrometheusAwareStatsCounter
implements StatsCounter {
    private final StatsCounter delegate;
    private final CounterDataPoint hitMetric;
    private final CounterDataPoint missMetric;
    private final CounterDataPoint evictionCountMetric;
    private final CounterDataPoint evictionWeightMetric;

    private PrometheusAwareStatsCounter(StatsCounter delegate, Counter counter) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.hitMetric = (CounterDataPoint)counter.labelValues(new String[]{"hit"});
        this.missMetric = (CounterDataPoint)counter.labelValues(new String[]{"miss"});
        this.evictionCountMetric = (CounterDataPoint)counter.labelValues(new String[]{"eviction_count"});
        this.evictionWeightMetric = (CounterDataPoint)counter.labelValues(new String[]{"eviction_weight"});
    }

    public static PrometheusAwareStatsCounter of(Counter counter) {
        return new PrometheusAwareStatsCounter((StatsCounter)new ConcurrentStatsCounter(), counter);
    }

    public void recordHits(int count) {
        this.hitMetric.inc((long)count);
        this.delegate.recordHits(count);
    }

    public void recordMisses(int count) {
        this.missMetric.inc((long)count);
        this.delegate.recordMisses(count);
    }

    public void recordLoadSuccess(long loadTime) {
        this.delegate.recordLoadSuccess(loadTime);
    }

    public void recordLoadFailure(long loadTime) {
        this.delegate.recordLoadFailure(loadTime);
    }

    public void recordEviction(int weight, @NonNull RemovalCause cause) {
        this.evictionCountMetric.inc();
        this.evictionWeightMetric.inc((long)weight);
        this.delegate.recordEviction(weight, cause);
    }

    public @NonNull CacheStats snapshot() {
        return this.delegate.snapshot();
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

