/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.lib.commons.collections.PairList;

public class ReadOnlyStore
extends DelegatingStore {
    public ReadOnlyStore(IStore store) {
        super(store);
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        ReadOnlyStore.denyWriteAccess();
    }

    private static void denyWriteAccess() throws StorageException {
        throw new StorageException("This store is read-only!");
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        ReadOnlyStore.denyWriteAccess();
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        ReadOnlyStore.denyWriteAccess();
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        ReadOnlyStore.denyWriteAccess();
    }
}

