/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.logging.google;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.logging.google.GoogleCloudLogSender;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="GoogleCloudLog", category="Core", elementType="appender", printObject=true)
public class GoogleCloudLogAppender
extends AbstractAppender {
    private static final String GOOGLE_CLOUD_PLATFORM_LOG_APPENDER_NAME = "GoogleCloudLogAppender";
    private static final long MAX_BATCH_INTERVAL = 10000L;
    private static final long MIN_BATCH_INTERVAL = 1000L;
    private static final int MAX_BATCH_SIZE = 10;
    private final GoogleCloudLogSender sender;

    private GoogleCloudLogAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, int maxBatchSize, long maxInterval, long minInterval) throws IOException, ServiceCallException {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        this.sender = new GoogleCloudLogSender(maxBatchSize, maxInterval, minInterval);
    }

    @PluginFactory
    public static GoogleCloudLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Layout") Layout<?> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="maxBatchSize", defaultInt=10) int maxBatchSize, @PluginAttribute(value="maxInterval", defaultLong=10000L) long maxInterval, @PluginAttribute(value="minInterval", defaultLong=1000L) long minInterval) {
        if (name == null) {
            LOGGER.error("No name provided for GoogleCloudLogAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        try {
            return new GoogleCloudLogAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, maxBatchSize, maxInterval, minInterval);
        }
        catch (ServiceCallException | IOException e) {
            LOGGER.error("Could not create GoogleCloudLogAppender.", e);
            return null;
        }
    }

    public void append(LogEvent event) {
        this.sender.send(event);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        this.sender.close();
        super.stop(timeout, timeUnit, false);
        this.setStopped();
        return true;
    }
}

