/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.distributedtask.webapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.AgentJobRequestMessage;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.JobRequestMessage;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.ServerJobRequestMessage;
import java.io.IOException;

public class JobRequestMessageDeserializer
extends JsonDeserializer<JobRequestMessage> {
    public static final String AGENT_JOB_REQUEST = "JobRequest";
    public static final String SERVER_JOB_REQUEST = "ServerJobRequest";

    public JobRequestMessage deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        if (rootNode == null) {
            return null;
        }
        Object newValue = null;
        JsonNode messageTypeNode = rootNode.findValue("MessageType");
        if (messageTypeNode != null && messageTypeNode.isTextual()) {
            String messageType = messageTypeNode.asText();
            if (AGENT_JOB_REQUEST.equalsIgnoreCase(messageTypeNode.asText())) {
                return (JobRequestMessage)rootNode.traverse((ObjectCodec)mapper).readValueAs(AgentJobRequestMessage.class);
            }
            if (SERVER_JOB_REQUEST.equalsIgnoreCase(messageTypeNode.asText())) {
                return (JobRequestMessage)rootNode.traverse((ObjectCodec)mapper).readValueAs(ServerJobRequestMessage.class);
            }
        }
        if (rootNode.findValue("RequestId") != null) {
            return (JobRequestMessage)rootNode.traverse((ObjectCodec)mapper).readValueAs(AgentJobRequestMessage.class);
        }
        return null;
    }
}

