/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.location.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.location.ConnectionData;
import com.microsoft.alm.visualstudio.services.location.ServiceDefinition;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.ConnectOptions;
import com.microsoft.alm.visualstudio.services.webapi.VssJsonCollectionWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class LocationHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected LocationHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public ConnectionData getConnectionData(ConnectOptions connectOptions, Integer lastChangeId, Integer lastChangeId64) {
        UUID locationId = UUID.fromString("00d9565f-ed9c-4a06-9a50-00e7896ccab4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("connectOptions", connectOptions);
        queryParameters.addIfNotNull("lastChangeId", lastChangeId);
        queryParameters.addIfNotNull("lastChangeId64", lastChangeId64);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ConnectionData.class);
    }

    public void deleteServiceDefinition(String serviceType, UUID identifier) {
        UUID locationId = UUID.fromString("d810a47d-f4f4-4a62-a03f-fa1860585c4c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("serviceType", serviceType);
        routeValues.put("identifier", identifier);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ServiceDefinition getServiceDefinition(String serviceType, UUID identifier, Boolean allowFaultIn) {
        UUID locationId = UUID.fromString("d810a47d-f4f4-4a62-a03f-fa1860585c4c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("serviceType", serviceType);
        routeValues.put("identifier", identifier);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("allowFaultIn", allowFaultIn);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ServiceDefinition.class);
    }

    public ArrayList<ServiceDefinition> getServiceDefinitions(String serviceType) {
        UUID locationId = UUID.fromString("d810a47d-f4f4-4a62-a03f-fa1860585c4c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("serviceType", serviceType);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ServiceDefinition>>(){});
    }

    public void updateServiceDefinitions(VssJsonCollectionWrapper<List<ServiceDefinition>> serviceDefinitions) {
        UUID locationId = UUID.fromString("d810a47d-f4f4-4a62-a03f-fa1860585c4c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, apiVersion, serviceDefinitions, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public void updateSpsServiceDefinition(UUID hostId) {
        UUID locationId = UUID.fromString("df5f298a-4e06-4815-a13e-6ce90a37efa4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("hostId", hostId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }
}

