/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.BuildConstants;
import com.microsoft.tfs.core.clients.build.IBuildAgent;
import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IBuildServiceHost;
import com.microsoft.tfs.core.clients.build.flags.BuildControllerUpdate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.AttachedPropertyDictionary;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2008Helper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildValidation;
import com.microsoft.tfs.core.clients.build.soapextensions.Agent2008Status;
import com.microsoft.tfs.core.clients.build.soapextensions.ControllerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import ms.tfs.build.buildservice._04._BuildController;
import ms.tfs.build.buildservice._04._PropertyValue;

public class BuildController
extends WebServiceObjectWrapper
implements IBuildController {
    private BuildControllerUpdateOptions lastSnapshot;
    private IBuildServiceHost serviceHost;
    private final BuildServer buildServer;
    private List<IBuildAgent> agents = new ArrayList<IBuildAgent>();
    private AttachedPropertyDictionary attachedProperties = new AttachedPropertyDictionary();
    private final Object lockProperties = new Object();

    private BuildController(IBuildServer buildServer) {
        super(new _BuildController());
        Check.notNull(buildServer, "buildServer");
        this.buildServer = (BuildServer)buildServer;
        this.getWebServiceObject().setTags(new String[0]);
        this.getWebServiceObject().setProperties(new _PropertyValue[0]);
    }

    public BuildController(IBuildServer buildServer, _BuildController webServiceObject) {
        super(webServiceObject);
        this.buildServer = (BuildServer)buildServer;
    }

    public BuildController(IBuildServer buildServer, BuildServiceHost serviceHost, String name) {
        this(buildServer);
        _BuildController _o = this.getWebServiceObject();
        _o.setName(name);
        _o.setMaxConcurrentBuilds(0);
        _o.setCustomAssemblyPath(null);
        _o.setTags(new String[0]);
        this.setServiceHost(serviceHost);
        this.lastSnapshot = this.getSnapshot();
        _o.setStatus(ControllerStatus.OFFLINE.getWebServiceObject());
        _o.setEnabled(true);
    }

    public BuildController(IBuildServer buildServer, BuildController2010 controller2010) {
        this(buildServer);
        _BuildController _o = this.getWebServiceObject();
        _o.setCustomAssemblyPath(controller2010.getCustomAssemblyPath());
        _o.setDateCreated(controller2010.getDateCreated());
        _o.setDateUpdated(controller2010.getDateUpdated());
        _o.setDescription(controller2010.getDescription());
        _o.setEnabled(controller2010.isEnabled());
        _o.setName(controller2010.getName());
        _o.setServiceHostUri(controller2010.getServiceHostURI());
        _o.setStatus(TFS2010Helper.convert(controller2010.getStatus()).getWebServiceObject());
        _o.setStatusMessage(controller2010.getStatusMessage());
        _o.setTags(controller2010.getTags());
        _o.setUri(controller2010.getURI());
        _o.setUrl(controller2010.getURL());
        this.afterDeserialize();
    }

    public BuildController(IBuildServer buildServer, BuildAgent2008 agent2008) {
        this(buildServer);
        _BuildController _o = this.getWebServiceObject();
        _o.setDescription(agent2008.getDescription());
        _o.setName(agent2008.getFullPath());
        _o.setQueueCount(agent2008.getQueueCount());
        _o.setStatus(TFS2008Helper.convert(agent2008.getStatus()).getWebServiceObject());
        _o.setEnabled(agent2008.getStatus() != Agent2008Status.DISABLED);
        _o.setServiceHostUri(agent2008.getURI());
        _o.setStatusMessage(agent2008.getStatusMessage());
        _o.setUri(agent2008.getURI());
        this.afterDeserialize();
    }

    public _BuildController getWebServiceObject() {
        return (_BuildController)this.webServiceObject;
    }

    @Override
    public String getCustomAssemblyPath() {
        return this.getWebServiceObject().getCustomAssemblyPath();
    }

    @Override
    public void setCustomAssemblyPath(String value) {
        this.getWebServiceObject().setCustomAssemblyPath(value);
    }

    @Override
    public Calendar getDateCreated() {
        return this.getWebServiceObject().getDateCreated();
    }

    @Override
    public Calendar getDateUpdated() {
        return this.getWebServiceObject().getDateUpdated();
    }

    @Override
    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    @Override
    public void setDescription(String value) {
        this.getWebServiceObject().setDescription(value);
    }

    @Override
    public boolean isEnabled() {
        return this.getWebServiceObject().isEnabled();
    }

    @Override
    public void setEnabled(boolean value) {
        this.getWebServiceObject().setEnabled(value);
    }

    public PropertyValue[] getInternalProperties() {
        return (PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getProperties());
    }

    public void setInternalProperties(PropertyValue[] value) {
        this.getWebServiceObject().setProperties((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, value));
    }

    @Override
    public int getMaxConcurrentBuilds() {
        return this.getWebServiceObject().getMaxConcurrentBuilds();
    }

    @Override
    public void setMaxConcurrentBuilds(int value) {
        this.getWebServiceObject().setMaxConcurrentBuilds(value);
    }

    @Override
    public String getMessageQueueURL() {
        return this.getWebServiceObject().getMessageQueueUrl();
    }

    @Override
    public String getName() {
        return this.getWebServiceObject().getName();
    }

    @Override
    public void setName(String value) {
        this.getWebServiceObject().setName(value);
    }

    @Override
    public int getQueueCount() {
        return this.getWebServiceObject().getQueueCount();
    }

    public void setQueueCount(int value) {
        this.getWebServiceObject().setQueueCount(value);
    }

    public String getServiceHostURI() {
        return this.getWebServiceObject().getServiceHostUri();
    }

    @Override
    public ControllerStatus getStatus() {
        return ControllerStatus.fromWebServiceObject(this.getWebServiceObject().getStatus());
    }

    @Override
    public void setStatus(ControllerStatus value) {
        this.getWebServiceObject().setStatus(value.getWebServiceObject());
    }

    @Override
    public String getStatusMessage() {
        return this.getWebServiceObject().getStatusMessage();
    }

    @Override
    public void setStatusMessage(String value) {
        this.getWebServiceObject().setStatusMessage(value);
    }

    @Override
    public String getURI() {
        return this.getWebServiceObject().getUri();
    }

    public void setURI(String value) {
        this.getWebServiceObject().setUri(value);
    }

    @Override
    public String getURL() {
        return this.getWebServiceObject().getUrl();
    }

    public void setURL(String value) {
        this.getWebServiceObject().setUrl(value);
    }

    @Override
    public IBuildServiceHost getServiceHost() {
        if (this.serviceHost == null && this.getWebServiceObject().getServiceHostUri() != null) {
            this.serviceHost = this.buildServer.getBuildServiceHostByURI(this.getWebServiceObject().getServiceHostUri());
        }
        return this.serviceHost;
    }

    public void setServiceHost(IBuildServiceHost value) {
        this.serviceHost = value;
        if (this.serviceHost != null) {
            this.getWebServiceObject().setServiceHostUri(this.serviceHost.getURI());
        } else {
            this.getWebServiceObject().setServiceHostUri(null);
        }
    }

    @Override
    public IBuildAgent[] getAgents() {
        return this.agents.toArray(new IBuildAgent[this.agents.size()]);
    }

    public void setAgents(List<IBuildAgent> value) {
        this.agents = value;
    }

    @Override
    public String[] getTags() {
        if (this.agents != null) {
            ArrayList<String> tags = new ArrayList<String>();
            for (IBuildAgent agent : this.agents) {
                for (String tag : agent.getTags()) {
                    if (tags.contains(tag)) continue;
                    tags.add(tag);
                }
            }
            return tags.toArray(new String[tags.size()]);
        }
        return this.getWebServiceObject().getTags();
    }

    public void setTags(String[] value) {
        this.getWebServiceObject().setTags(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachedPropertyDictionary getAttachedProperties() {
        Object object = this.lockProperties;
        synchronized (object) {
            if (this.attachedProperties == null) {
                this.attachedProperties = new AttachedPropertyDictionary();
            }
            return this.attachedProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttachedProperties(AttachedPropertyDictionary value) {
        Object object = this.lockProperties;
        synchronized (object) {
            this.attachedProperties = value;
        }
    }

    @Override
    public void addBuildAgent(IBuildAgent agent) {
        if (!this.agents.contains(agent)) {
            this.agents.add(agent);
            agent.setController(this);
        }
    }

    @Override
    public void delete() {
        if (this.getURI() != null) {
            this.serviceHost.getBuildServer().deleteBuildControllers(new String[]{this.getURI()});
        }
    }

    @Override
    public void refresh(boolean refreshAgentList) {
        if (this.getURI() != null) {
            this.copy(this.serviceHost.getBuildServer().getBuildController(this.getURI(), BuildConstants.NO_PROPERTY_NAMES, refreshAgentList), refreshAgentList);
        }
    }

    @Override
    public void refresh(String[] propertyNameFilters, boolean refreshAgentList) {
        if (this.getURI() != null) {
            this.copy(this.serviceHost.getBuildServer().getBuildController(this.getURI(), propertyNameFilters, refreshAgentList), refreshAgentList);
        }
    }

    public void copy(IBuildController controller, boolean copyAgentList) {
        if (controller != null) {
            if (copyAgentList) {
                HashMap<String, BuildAgent> agentsToCopy = new HashMap<String, BuildAgent>();
                for (IBuildAgent agent : controller.getAgents()) {
                    agentsToCopy.put(agent.getURI(), (BuildAgent)agent);
                }
                ArrayList<IBuildAgent> agentsToDelete = new ArrayList<IBuildAgent>();
                for (IBuildAgent agent : this.agents) {
                    if (agent.getURI() == null) continue;
                    if (agentsToCopy.containsKey(agent.getURI())) {
                        BuildAgent agentToCopy = (BuildAgent)agentsToCopy.get(agent.getURI());
                        ((BuildAgent)agent).copy(agentToCopy);
                        agentsToCopy.remove(agentToCopy.getURI());
                        continue;
                    }
                    agentsToDelete.add(agent);
                }
                for (BuildAgent agent : agentsToCopy.values()) {
                    agent.setController(this);
                }
                for (IBuildAgent agent : agentsToDelete) {
                    this.agents.remove(agent);
                }
            }
            this.setCustomAssemblyPath(controller.getCustomAssemblyPath());
            this.setDescription(controller.getDescription());
            this.setMaxConcurrentBuilds(controller.getMaxConcurrentBuilds());
            this.setName(controller.getName());
            this.setQueueCount(controller.getQueueCount());
            this.serviceHost = controller.getServiceHost();
            this.setStatus(controller.getStatus());
            this.setEnabled(controller.isEnabled());
            this.setStatusMessage(controller.getStatusMessage());
            this.setTags(controller.getTags());
            this.setURL(controller.getURL());
            this.setAttachedProperties(((BuildController)controller).getAttachedProperties());
            this.lastSnapshot = this.getSnapshot();
        }
    }

    @Override
    public void removeBuildAgent(IBuildAgent agent) {
        if (this.agents.remove(agent)) {
            agent.setController(null);
        }
    }

    public void afterDeserialize() {
        this.attachedProperties = new AttachedPropertyDictionary(this.getInternalProperties());
        this.lastSnapshot = this.getSnapshot();
    }

    private BuildControllerUpdate compareSnapshots(BuildControllerUpdateOptions originalValues, BuildControllerUpdateOptions modifiedValues) {
        BuildControllerUpdate result = BuildControllerUpdate.NONE;
        if (!ServerPath.equals(originalValues.getCustomAssemblyPath(), modifiedValues.getCustomAssemblyPath())) {
            result = result.combine(BuildControllerUpdate.CUSTOM_ASSEMBLY_PATH);
        }
        if (!originalValues.getDescription().equals(modifiedValues.getDescription())) {
            result = result.combine(BuildControllerUpdate.DESCRIPTION);
        }
        if (originalValues.getMaxConcurrentBuilds() != modifiedValues.getMaxConcurrentBuilds()) {
            result = result.combine(BuildControllerUpdate.MAX_CONCURRENT_BUILDS);
        }
        if (!originalValues.getName().equals(modifiedValues.getName())) {
            result = result.combine(BuildControllerUpdate.NAME);
        }
        if (!originalValues.getStatus().equals(modifiedValues.getStatus())) {
            result = result.combine(BuildControllerUpdate.STATUS);
        }
        if (originalValues.isEnabled() != modifiedValues.isEnabled()) {
            result = result.combine(BuildControllerUpdate.ENABLED);
        }
        if (!originalValues.getStatusMessage().equals(modifiedValues.getStatusMessage())) {
            result = result.combine(BuildControllerUpdate.STATUS_MESSAGE);
        }
        if (modifiedValues.getAttachedProperties().length > 0) {
            result = result.combine(BuildControllerUpdate.ATTACHED_PROPERTIES);
        }
        return result;
    }

    private BuildControllerUpdateOptions getSnapshot() {
        BuildControllerUpdateOptions result = new BuildControllerUpdateOptions();
        result.setCustomAssemblyPath(this.getCustomAssemblyPath());
        result.setDescription(this.getDescription());
        result.setMaxConcurrentBuilds(this.getMaxConcurrentBuilds());
        result.setName(this.getName());
        result.setStatus(this.getStatus());
        result.setEnabled(this.isEnabled());
        result.setStatusMessage(this.getStatusMessage());
        result.setURI(this.getURI());
        result.setAttachedProperties(this.attachedProperties.getChangedProperties());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildControllerUpdateOptions getUpdateOptions() {
        BuildControllerUpdateOptions currentSnapshot;
        BuildControllerUpdateOptions buildControllerUpdateOptions = this.lastSnapshot;
        synchronized (buildControllerUpdateOptions) {
            currentSnapshot = this.getSnapshot();
            currentSnapshot.setFields(this.compareSnapshots(this.lastSnapshot, currentSnapshot));
        }
        return currentSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateOptions(BuildControllerUpdateOptions snapshot) {
        BuildControllerUpdateOptions buildControllerUpdateOptions = this.lastSnapshot;
        synchronized (buildControllerUpdateOptions) {
            this.lastSnapshot = snapshot;
        }
        this.attachedProperties.clearChangedProperties();
    }

    @Override
    public void save() {
        this.serviceHost.getBuildServer().saveBuildControllers(new IBuildController[]{this});
    }

    public void prepareToSave() {
        BuildValidation.checkValidControllerName(this.getName(), false);
        this.setInternalProperties(this.attachedProperties.getChangedProperties());
    }

    @Override
    public int hashCode() {
        if (this.getURI() == null) {
            return 0;
        }
        return this.getURI().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuildController)) {
            return false;
        }
        BuildController other = (BuildController)obj;
        if (this.getURI() == null) {
            return false;
        }
        return this.getURI().equals(other.getURI());
    }
}

