/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.sharepoint;

import com.microsoft.tfs.core.clients.sharepoint.WSSDocument;
import com.microsoft.tfs.core.clients.sharepoint.WSSFolder;
import com.microsoft.tfs.core.clients.sharepoint.WSSUtils;
import com.microsoft.tfs.core.util.Hierarchical;
import com.microsoft.tfs.core.util.Labelable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSSNode
implements Hierarchical,
Labelable,
Comparable {
    private static final Log log = LogFactory.getLog(WSSNode.class);
    private Object parent;
    private final List children = new ArrayList();
    private String wssObjectType;
    private String fullPath;
    private String label;
    private String editor;
    private String path;
    private boolean childrenSorted = false;

    public WSSNode() {
    }

    public WSSNode(Element element) {
        this.wssObjectType = WSSUtils.decodeWSSString(element.getAttribute("ows_FSObjType"));
        this.fullPath = WSSUtils.decodeWSSString(element.getAttribute("ows_FileRef"));
        this.label = WSSUtils.decodeWSSString(element.getAttribute("ows_FileLeafRef"));
        this.editor = WSSUtils.decodeWSSString(element.getAttribute("ows_Editor"));
        this.path = this.fullPath.substring(0, this.fullPath.length() - this.label.length() - 1);
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void addChild(Object child) {
        if (child instanceof WSSNode) {
            ((WSSNode)child).setParent(this);
        }
        this.children.add(child);
        this.childrenSorted = false;
    }

    @Override
    public Object[] getChildren() {
        if (!this.childrenSorted) {
            Collections.sort(this.children);
            this.childrenSorted = true;
        }
        return this.children.toArray();
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public String getWSSObjectType() {
        return this.wssObjectType;
    }

    public void setWSSObjectType(String wssObjectType) {
        this.wssObjectType = wssObjectType;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public static WSSNode buildWSSNode(Element element) {
        String wssObjType = WSSUtils.decodeWSSString(element.getAttribute("ows_FSObjType"));
        if ("0".equals(wssObjType)) {
            return new WSSDocument(element);
        }
        if ("1".equals(wssObjType)) {
            return new WSSFolder(element);
        }
        return new WSSNode(element);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int compareTo(Object compare) {
        if (!(compare instanceof WSSNode)) {
            throw new ClassCastException(MessageFormat.format("A WssNode to compare against was expected, class passed was {0}", compare.getClass().getName()));
        }
        WSSNode anotherNode = (WSSNode)compare;
        if (this.fullPath.equals(anotherNode.getFullPath())) {
            return 0;
        }
        if ("1".equals(this.getWSSObjectType()) && "0".equals(anotherNode.getWSSObjectType())) {
            return -1;
        }
        if ("0".equals(this.getWSSObjectType()) && "1".equals(anotherNode.getWSSObjectType())) {
            return 1;
        }
        return this.getFullPath().compareTo(anotherNode.getFullPath());
    }
}

