/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.sharepoint;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectPortalEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.clients.sharepoint.WSSDocumentLibrary;
import com.microsoft.tfs.core.clients.sharepoint.WSSNode;
import com.microsoft.tfs.core.util.Hierarchical;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WSSUtils {
    private static final Log log = LogFactory.getLog(WSSUtils.class);

    private WSSUtils() {
    }

    public static boolean isWSSConfigured(TFSTeamProjectCollection connection, ProjectInfo projectInfo) {
        Check.notNull(connection, "connection");
        Check.notNull(projectInfo, "projectInfo");
        ProjectCollectionEntity projectCollectionEntity = connection.getTeamProjectCollectionEntity(false);
        if (projectCollectionEntity == null) {
            log.warn((Object)"Could not load team project collection catalog entity");
            return false;
        }
        TeamProjectEntity teamProject = projectCollectionEntity.getTeamProject(new GUID(projectInfo.getGUID()));
        if (teamProject == null) {
            log.warn((Object)MessageFormat.format("Could not team project catalog entity for team project {0}", projectInfo.getName()));
            return false;
        }
        ProjectPortalEntity projectPortal = teamProject.getProjectPortal();
        return projectPortal != null && projectPortal.getResourceSubType().equals("WssSite");
    }

    public static String decodeWSSString(String valueToDecode) {
        return valueToDecode.substring(valueToDecode.lastIndexOf(35) + 1);
    }

    public static String getWSSURL(TFSTeamProjectCollection connection, ProjectInfo projectInfo) {
        Check.notNull(connection, "connection");
        Check.notNull(projectInfo, "projectInfo");
        TeamProjectEntity teamProject = connection.getTeamProjectCollectionEntity(false).getTeamProject(new GUID(projectInfo.getGUID()));
        if (teamProject == null) {
            log.warn((Object)MessageFormat.format("Could not load project collection catalog entity for team project {0}", projectInfo.getName()));
            return null;
        }
        ProjectPortalEntity projectPortal = teamProject.getProjectPortal();
        if (projectPortal != null) {
            return projectPortal.getFullItemPath();
        }
        return null;
    }

    public static URI getViewURI(Hierarchical wssNode) throws URISyntaxException {
        String path = null;
        if (wssNode instanceof WSSDocumentLibrary) {
            path = ((WSSDocumentLibrary)wssNode).getDefaultViewURL();
        }
        if (wssNode instanceof WSSNode) {
            path = ((WSSNode)wssNode).getFullPath();
        }
        if (path == null) {
            return new URI(null, null, null, null);
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = "/" + path;
        }
        return new URI(null, null, path, null);
    }
}

