/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.TypesafeEnum;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConflictCategory
extends TypesafeEnum {
    public static final ConflictCategory UNKNOWN = new ConflictCategory(0);
    public static final ConflictCategory VERSION = new ConflictCategory(1);
    public static final ConflictCategory MERGE = new ConflictCategory(2);
    public static final ConflictCategory SERVER_DELETED = new ConflictCategory(3);
    public static final ConflictCategory MERGE_TARGET_DELETED = new ConflictCategory(4);
    public static final ConflictCategory LOCALLY_DELETED = new ConflictCategory(5);
    public static final ConflictCategory MERGE_SOURCE_DELETED = new ConflictCategory(6);
    public static final ConflictCategory BOTH_DELETED = new ConflictCategory(7);
    public static final ConflictCategory MERGE_BOTH_DELETED = new ConflictCategory(8);
    public static final ConflictCategory FILENAME = new ConflictCategory(9);
    public static final ConflictCategory WRITABLE = new ConflictCategory(10);
    public static final ConflictCategory SHELVESET = new ConflictCategory(11);
    public static final ConflictCategory ROLLBACK_LOCAL = new ConflictCategory(12);
    private static final Log log = LogFactory.getLog(ConflictCategory.class);

    protected ConflictCategory(int value) {
        super(value);
    }

    public static ConflictCategory[] getAllConflictCategories() {
        return new ConflictCategory[]{UNKNOWN, VERSION, MERGE, SERVER_DELETED, MERGE_TARGET_DELETED, LOCALLY_DELETED, BOTH_DELETED, MERGE_BOTH_DELETED, FILENAME, WRITABLE, SHELVESET, ROLLBACK_LOCAL};
    }

    public static ConflictCategory getConflictCategory(Conflict conflict) {
        Check.notNull(conflict, "conflict");
        if (conflict.getReason() == OperationStatus.CONFLICT.getValue()) {
            if (conflict.getTheirShelvesetName() != null && conflict.getTheirShelvesetOwnerName() != null) {
                return SHELVESET;
            }
            if (conflict.getTheirDeletionID() > 0 && conflict.getYourChangeType().contains(ChangeType.DELETE)) {
                if (conflict.getType() == ConflictType.MERGE) {
                    return MERGE_BOTH_DELETED;
                }
                return BOTH_DELETED;
            }
            if (conflict.getYourChangeType().contains(ChangeType.DELETE)) {
                if (conflict.getType() == ConflictType.MERGE) {
                    return MERGE_TARGET_DELETED;
                }
                return LOCALLY_DELETED;
            }
            if (conflict.getTheirDeletionID() > 0) {
                if (conflict.getType() == ConflictType.MERGE) {
                    return MERGE_SOURCE_DELETED;
                }
                return SERVER_DELETED;
            }
            if (conflict.getType() != ConflictType.MERGE && (conflict.getBaseServerItem() == null || conflict.isNamespaceConflict())) {
                return FILENAME;
            }
            if (conflict.getType() == ConflictType.MERGE && conflict.getBaseChangeType().contains(ChangeType.ROLLBACK)) {
                return ROLLBACK_LOCAL;
            }
            if (conflict.getType() == ConflictType.MERGE) {
                return MERGE;
            }
            return VERSION;
        }
        if (conflict.getReason() == OperationStatus.SOURCE_WRITABLE.getValue() || conflict.getReason() == OperationStatus.TARGET_WRITABLE.getValue()) {
            return WRITABLE;
        }
        if (conflict.isNamespaceConflict()) {
            return FILENAME;
        }
        log.error((Object)MessageFormat.format("Could not determine conflict category for conflict: {0}", conflict.getReason()));
        return UNKNOWN;
    }
}

