/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal;

import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaseDownloadOutput;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileDownloadOutput
extends BaseDownloadOutput {
    private static final Log log = LogFactory.getLog(FileDownloadOutput.class);
    private final File outputFile;
    private FileOutputStream outputStream;

    public FileDownloadOutput(File outputFile, boolean autoGunzip) {
        super(autoGunzip);
        Check.notNull(outputFile, "outputFile");
        this.outputFile = outputFile;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws FileNotFoundException {
        if (this.outputStream == null) {
            if (!(this.outputFile.getParentFile().exists() || this.outputFile.getParentFile().mkdirs() || this.outputFile.getParentFile().isDirectory())) {
                log.warn((Object)MessageFormat.format("mkdirs() failed on {0}, output stream will probably fail", this.outputFile.getParentFile()));
            }
            this.outputStream = new FileOutputStream(this.outputFile);
        }
        return this.outputStream;
    }

    @Override
    public synchronized void resetOutputStream() throws IOException {
        this.closeOutputStream();
    }

    @Override
    public void closeOutputStream() throws IOException {
        if (this.outputStream != null) {
            IOUtils.closeSafely(this.outputStream);
            this.outputStream = null;
        }
    }
}

