/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.events;

import com.microsoft.tfs.core.clients.versioncontrol.events.BeforeCheckinListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.BeforeShelveListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.BranchCommittedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.BranchCommittedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.BranchObjectUpdatedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.BranchObjectUpdatedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.ChangesetReconciledEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ChangesetReconciledListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.CheckinEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.CheckinListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.DestroyEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.DestroyListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.FolderContentChangedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.FolderContentChangedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetCompletedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.GetListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.LocalWorkspaceScanListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.MergingEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.MergingListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.NewPendingChangeListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationCompletedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationCompletedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationStartedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.OperationStartedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendingChangeCandidatesChangedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendingChangeEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.PendingChangesChangedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.ScannerModifiedFilesEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ScannerModifiedFilesListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.ShelveEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.ShelveListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.UndonePendingChangeListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceCacheFileReloadedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceCacheFileReloadedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceCreatedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceDeletedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkspaceUpdatedListener;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkstationNonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.WorkstationNonFatalErrorListener;
import com.microsoft.tfs.util.listeners.ListenerCategory;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import com.microsoft.tfs.util.listeners.MultiListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class VersionControlEventEngine {
    private static final Log log = LogFactory.getLog(VersionControlEventEngine.class);
    private final MultiListenerList listeners = new MultiListenerList();
    private static final ListenerCategory WORKSPACE_CREATED = new ListenerCategory(WorkspaceCreatedListener.class);
    private static final ListenerCategory WORKSPACE_UPDATED = new ListenerCategory(WorkspaceUpdatedListener.class);
    private static final ListenerCategory WORKSPACE_DELETED = new ListenerCategory(WorkspaceDeletedListener.class);
    private static final ListenerCategory NON_FATAL_ERROR = new ListenerCategory(NonFatalErrorListener.class);
    private static final ListenerCategory WORKSTATION_NON_FATAL_ERROR = new ListenerCategory(WorkstationNonFatalErrorListener.class);
    private static final ListenerCategory GET = new ListenerCategory(GetListener.class);
    private static final ListenerCategory NEW_PENDING_CHANGE = new ListenerCategory(NewPendingChangeListener.class);
    private static final ListenerCategory UNDONE_PENDING_CHANGE = new ListenerCategory(UndonePendingChangeListener.class);
    private static final ListenerCategory BEFORE_CHECKIN = new ListenerCategory(BeforeCheckinListener.class);
    private static final ListenerCategory CHECKIN = new ListenerCategory(CheckinListener.class);
    private static final ListenerCategory BEFORE_SHELVE = new ListenerCategory(BeforeShelveListener.class);
    private static final ListenerCategory SHELVE = new ListenerCategory(ShelveListener.class);
    private static final ListenerCategory CONFLICT = new ListenerCategory(ConflictListener.class);
    private static final ListenerCategory CONFLICT_RESOLVED = new ListenerCategory(ConflictResolvedListener.class);
    private static final ListenerCategory OPERATION_STARTED = new ListenerCategory(OperationStartedListener.class);
    private static final ListenerCategory OPERATION_COMPLETED = new ListenerCategory(OperationCompletedListener.class);
    private static final ListenerCategory MERGING = new ListenerCategory(MergingListener.class);
    private static final ListenerCategory DESTROY = new ListenerCategory(DestroyListener.class);
    private static final ListenerCategory BRANCH_COMMITTED = new ListenerCategory(BranchCommittedListener.class);
    private static final ListenerCategory BRANCH_OBJECT_UPDATED = new ListenerCategory(BranchObjectUpdatedListener.class);
    private static final ListenerCategory SCANNER_MODIFIED_FILES = new ListenerCategory(ScannerModifiedFilesListener.class);
    private static final ListenerCategory PENDING_CHANGES_CHANGED = new ListenerCategory(PendingChangesChangedListener.class);
    private static final ListenerCategory PENDING_CHANGE_CANDIDATES_CHANGED = new ListenerCategory(PendingChangeCandidatesChangedListener.class);
    private static final ListenerCategory GET_COMPLETED = new ListenerCategory(GetCompletedListener.class);
    private static final ListenerCategory FOLDER_CONTENT_CHANGED = new ListenerCategory(FolderContentChangedListener.class);
    private static final ListenerCategory CHANGESET_RECONCILED = new ListenerCategory(ChangesetReconciledListener.class);
    private static final ListenerCategory WORKSPACE_CACHE_FILE_RELOADED = new ListenerCategory(WorkspaceCacheFileReloadedListener.class);
    private static final ListenerCategory LOCAL_WORKSPACE_SCAN = new ListenerCategory(LocalWorkspaceScanListener.class);

    public void fireWorkspaceCreated(final WorkspaceEvent event) {
        this.listeners.getListenerList(WORKSPACE_CREATED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((WorkspaceCreatedListener)listener).onWorkspaceCreated(event);
                return true;
            }
        });
    }

    public void fireWorkspaceUpdated(final WorkspaceUpdatedEvent event) {
        this.listeners.getListenerList(WORKSPACE_UPDATED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((WorkspaceUpdatedListener)listener).onWorkspaceUpdated(event);
                return true;
            }
        });
    }

    public void fireWorkspaceDeleted(final WorkspaceEvent event) {
        this.listeners.getListenerList(WORKSPACE_DELETED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((WorkspaceDeletedListener)listener).onWorkspaceDeleted(event);
                return true;
            }
        });
    }

    public void fireNonFatalError(final NonFatalErrorEvent event) {
        this.listeners.getListenerList(NON_FATAL_ERROR, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((NonFatalErrorListener)listener).onNonFatalError(event);
                return true;
            }
        });
    }

    public void fireWorkstationNonFatalError(final WorkstationNonFatalErrorEvent event) {
        this.listeners.getListenerList(WORKSTATION_NON_FATAL_ERROR, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((WorkstationNonFatalErrorListener)listener).onWorkstationNonFatalError(event);
                return true;
            }
        });
    }

    public void fireGet(final GetEvent event) {
        this.listeners.getListenerList(GET, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((GetListener)listener).onGet(event);
                return true;
            }
        });
    }

    public void fireNewPendingChange(final PendingChangeEvent event) {
        this.listeners.getListenerList(NEW_PENDING_CHANGE, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((NewPendingChangeListener)listener).onNewPendingChange(event);
                return true;
            }
        });
    }

    public void fireUndonePendingChange(final PendingChangeEvent event) {
        this.listeners.getListenerList(UNDONE_PENDING_CHANGE, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((UndonePendingChangeListener)listener).onUndonePendingChange(event);
                return true;
            }
        });
    }

    public void fireBeforeCheckinPendingChange(final PendingChangeEvent event) {
        this.listeners.getListenerList(BEFORE_CHECKIN, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((BeforeCheckinListener)listener).onBeforeCheckin(event);
                return true;
            }
        });
    }

    public void fireBeforeShelvePendingChange(final PendingChangeEvent event) {
        this.listeners.getListenerList(BEFORE_SHELVE, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((BeforeShelveListener)listener).onBeforeShelve(event);
                return true;
            }
        });
    }

    public void fireBranchCommitted(final BranchCommittedEvent event) {
        this.listeners.getListenerList(BRANCH_COMMITTED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((BranchCommittedListener)listener).onBranchCommitted(event);
                return true;
            }
        });
    }

    public void fireBranchObjectUpdated(final BranchObjectUpdatedEvent event) {
        this.listeners.getListenerList(BRANCH_OBJECT_UPDATED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((BranchObjectUpdatedListener)listener).onBranchObjectUpdated(event);
                return true;
            }
        });
    }

    public void fireScannerModifiedFile(final ScannerModifiedFilesEvent event) {
        this.listeners.getListenerList(SCANNER_MODIFIED_FILES, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((ScannerModifiedFilesListener)listener).onScannerModifiedFiles(event);
                return true;
            }
        });
    }

    public void fireCheckin(final CheckinEvent event) {
        this.listeners.getListenerList(CHECKIN, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((CheckinListener)listener).onCheckin(event);
                return true;
            }
        });
    }

    public void fireShelve(final ShelveEvent event) {
        this.listeners.getListenerList(SHELVE, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((ShelveListener)listener).onShelve(event);
                return true;
            }
        });
    }

    public void fireConflict(final ConflictEvent event) {
        this.listeners.getListenerList(CONFLICT, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((ConflictListener)listener).onConflict(event);
                return true;
            }
        });
    }

    public void fireConflictResolved(final ConflictResolvedEvent event) {
        this.listeners.getListenerList(CONFLICT_RESOLVED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((ConflictResolvedListener)listener).onConflictResolved(event);
                return true;
            }
        });
    }

    public void fireOperationStarted(final OperationStartedEvent event) {
        log.debug((Object)("Firing event OPERATION_STARTED from " + event.getEventSource().getOriginatingThread().getName()));
        this.listeners.getListenerList(OPERATION_STARTED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((OperationStartedListener)listener).onOperationStarted(event);
                return true;
            }
        });
    }

    public void fireOperationCompleted(final OperationCompletedEvent event) {
        log.debug((Object)("Firing event OPERATION_COMPLETED from " + event.getEventSource().getOriginatingThread().getName()));
        this.listeners.getListenerList(OPERATION_COMPLETED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((OperationCompletedListener)listener).onOperationCompleted(event);
                return true;
            }
        });
    }

    public void fireMerging(final MergingEvent event) {
        this.listeners.getListenerList(MERGING, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((MergingListener)listener).onMerging(event);
                return true;
            }
        });
    }

    public void fireDestroyEvent(final DestroyEvent event) {
        this.listeners.getListenerList(DESTROY, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((DestroyListener)listener).onDestroy(event);
                return true;
            }
        });
    }

    public void firePendingChangesChangedEvent(final WorkspaceEvent event) {
        this.listeners.getListenerList(PENDING_CHANGES_CHANGED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((PendingChangesChangedListener)listener).onPendingChangesChanged(event);
                return true;
            }
        });
    }

    public void firePendingChangeCandidatesChangedEvent(final WorkspaceEvent event) {
        this.listeners.getListenerList(PENDING_CHANGE_CANDIDATES_CHANGED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((PendingChangeCandidatesChangedListener)listener).onPendingChangeCandidatesChanged(event);
                return true;
            }
        });
    }

    public void fireGetCompletedEvent(final WorkspaceEvent event) {
        this.listeners.getListenerList(GET_COMPLETED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((GetCompletedListener)listener).onGetCompleted(event);
                return true;
            }
        });
    }

    public void fireFolderContentChangedEvent(final FolderContentChangedEvent event) {
        this.listeners.getListenerList(FOLDER_CONTENT_CHANGED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((FolderContentChangedListener)listener).onFolderContentChanged(event);
                return true;
            }
        });
    }

    public void fireChangesetReconciledEvent(final ChangesetReconciledEvent event) {
        this.listeners.getListenerList(CHANGESET_RECONCILED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((ChangesetReconciledListener)listener).onChangesetReconciled(event);
                return true;
            }
        });
    }

    public void fireWorkspaceCacheFileReloaded(final WorkspaceCacheFileReloadedEvent event) {
        this.listeners.getListenerList(WORKSPACE_CACHE_FILE_RELOADED, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((WorkspaceCacheFileReloadedListener)listener).onWorkspaceCacheFileReloaded(event);
                return true;
            }
        });
    }

    public void fireLocalWorkspaceScanEvent(final WorkspaceEvent event) {
        this.listeners.getListenerList(LOCAL_WORKSPACE_SCAN, true).foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((LocalWorkspaceScanListener)listener).onLocalWorkspaceScan(event);
                return true;
            }
        });
    }

    public void addWorkspaceCreatedListener(WorkspaceCreatedListener listener) {
        this.listeners.addListener(listener, WORKSPACE_CREATED);
    }

    public void removeWorkspaceCreatedListener(WorkspaceCreatedListener listener) {
        this.listeners.removeListener(listener, WORKSPACE_CREATED);
    }

    public void addWorkspaceUpdatedListener(WorkspaceUpdatedListener listener) {
        this.listeners.addListener(listener, WORKSPACE_UPDATED);
    }

    public void removeWorkspaceUpdatedListener(WorkspaceUpdatedListener listener) {
        this.listeners.removeListener(listener, WORKSPACE_UPDATED);
    }

    public void addWorkspaceDeletedListener(WorkspaceDeletedListener listener) {
        this.listeners.addListener(listener, WORKSPACE_DELETED);
    }

    public void removeWorkspaceDeletedListener(WorkspaceDeletedListener listener) {
        this.listeners.removeListener(listener, WORKSPACE_DELETED);
    }

    public void addNonFatalErrorListener(NonFatalErrorListener listener) {
        this.listeners.addListener(listener, NON_FATAL_ERROR);
    }

    public void removeNonFatalErrorListener(NonFatalErrorListener listener) {
        this.listeners.removeListener(listener, NON_FATAL_ERROR);
    }

    public void addWorkstationNonFatalErrorListener(WorkstationNonFatalErrorListener listener) {
        this.listeners.addListener(listener, WORKSTATION_NON_FATAL_ERROR);
    }

    public void removeWorkstationNonFatalErrorListener(WorkstationNonFatalErrorListener listener) {
        this.listeners.removeListener(listener, WORKSTATION_NON_FATAL_ERROR);
    }

    public void addGetListener(GetListener listener) {
        this.listeners.addListener(listener, GET);
    }

    public void removeGetListener(GetListener listener) {
        this.listeners.removeListener(listener, GET);
    }

    public void addNewPendingChangeListener(NewPendingChangeListener listener) {
        this.listeners.addListener(listener, NEW_PENDING_CHANGE);
    }

    public void removeNewPendingChangeListener(NewPendingChangeListener listener) {
        this.listeners.removeListener(listener, NEW_PENDING_CHANGE);
    }

    public void addUndonePendingChangeListener(UndonePendingChangeListener listener) {
        this.listeners.addListener(listener, UNDONE_PENDING_CHANGE);
    }

    public void removeUndonePendingChangeListener(UndonePendingChangeListener listener) {
        this.listeners.removeListener(listener, UNDONE_PENDING_CHANGE);
    }

    public void addBeforeCheckinListener(BeforeCheckinListener listener) {
        this.listeners.addListener(listener, BEFORE_CHECKIN);
    }

    public void removeBeforeCheckinListener(BeforeCheckinListener listener) {
        this.listeners.removeListener(listener, BEFORE_CHECKIN);
    }

    public void addBeforeShelveListener(BeforeShelveListener listener) {
        this.listeners.addListener(listener, BEFORE_SHELVE);
    }

    public void removeBeforeShelveListener(BeforeShelveListener listener) {
        this.listeners.removeListener(listener, BEFORE_SHELVE);
    }

    public void addCheckinListener(CheckinListener listener) {
        this.listeners.addListener(listener, CHECKIN);
    }

    public void removeCheckinListener(CheckinListener listener) {
        this.listeners.removeListener(listener, CHECKIN);
    }

    public void addShelveListener(ShelveListener listener) {
        this.listeners.addListener(listener, SHELVE);
    }

    public void removeShelveListener(ShelveListener listener) {
        this.listeners.removeListener(listener, SHELVE);
    }

    public void addOperationStartedListener(OperationStartedListener listener) {
        this.listeners.addListener(listener, OPERATION_STARTED);
    }

    public void removeOperationStartedListener(OperationStartedListener listener) {
        this.listeners.removeListener(listener, OPERATION_STARTED);
    }

    public void addOperationCompletedListener(OperationCompletedListener listener) {
        this.listeners.addListener(listener, OPERATION_COMPLETED);
    }

    public void removeOperationCompletedListener(OperationCompletedListener listener) {
        this.listeners.removeListener(listener, OPERATION_COMPLETED);
    }

    public void addConflictListener(ConflictListener listener) {
        this.listeners.addListener(listener, CONFLICT);
    }

    public void removeConflictListener(ConflictListener listener) {
        this.listeners.removeListener(listener, CONFLICT);
    }

    public void addConflictResolvedListener(ConflictResolvedListener listener) {
        this.listeners.addListener(listener, CONFLICT_RESOLVED);
    }

    public void removeConflictResolvedListener(ConflictResolvedListener listener) {
        this.listeners.removeListener(listener, CONFLICT_RESOLVED);
    }

    public void addMergingListener(MergingListener listener) {
        this.listeners.addListener(listener, MERGING);
    }

    public void removeMergingListener(MergingListener listener) {
        this.listeners.removeListener(listener, MERGING);
    }

    public void addDestroyListener(DestroyListener listener) {
        this.listeners.addListener(listener, DESTROY);
    }

    public void removeDestroyListener(DestroyListener listener) {
        this.listeners.removeListener(listener, DESTROY);
    }

    public void addBranchCommittedListener(BranchCommittedListener listener) {
        this.listeners.addListener(listener, BRANCH_COMMITTED);
    }

    public void removeBranchCommittedListener(BranchCommittedListener listener) {
        this.listeners.removeListener(listener, BRANCH_COMMITTED);
    }

    public void addBranchObjectUpdatedListener(BranchObjectUpdatedListener listener) {
        this.listeners.addListener(listener, BRANCH_OBJECT_UPDATED);
    }

    public void removeBranchObjectUpdatedListener(BranchObjectUpdatedListener listener) {
        this.listeners.removeListener(listener, BRANCH_OBJECT_UPDATED);
    }

    public void addScannerModifiedFilesListener(ScannerModifiedFilesListener listener) {
        this.listeners.addListener(listener, SCANNER_MODIFIED_FILES);
    }

    public void removeScannerModifiedFilesListener(ScannerModifiedFilesListener listener) {
        this.listeners.removeListener(listener, SCANNER_MODIFIED_FILES);
    }

    public void addPendingChangesChangedListener(PendingChangesChangedListener listener) {
        this.listeners.addListener(listener, PENDING_CHANGES_CHANGED);
    }

    public void removePendingChangesChangedListener(PendingChangesChangedListener listener) {
        this.listeners.removeListener(listener, PENDING_CHANGES_CHANGED);
    }

    public void addPendingChangeCandidatesChangedListener(PendingChangeCandidatesChangedListener listener) {
        this.listeners.addListener(listener, PENDING_CHANGE_CANDIDATES_CHANGED);
    }

    public void removePendingChangeCandidatesChangedListener(PendingChangeCandidatesChangedListener listener) {
        this.listeners.removeListener(listener, PENDING_CHANGE_CANDIDATES_CHANGED);
    }

    public void addGetCompletedListener(GetCompletedListener listener) {
        this.listeners.addListener(listener, GET_COMPLETED);
    }

    public void removeGetCompletedListener(GetCompletedListener listener) {
        this.listeners.removeListener(listener, GET_COMPLETED);
    }

    public void addFolderContentChangedListener(FolderContentChangedListener listener) {
        this.listeners.addListener(listener, FOLDER_CONTENT_CHANGED);
    }

    public void removeFolderContentChangedListener(FolderContentChangedListener listener) {
        this.listeners.removeListener(listener, FOLDER_CONTENT_CHANGED);
    }

    public void addChangesetReconciledListener(ChangesetReconciledListener listener) {
        this.listeners.addListener(listener, CHANGESET_RECONCILED);
    }

    public void removeChangesetReconciledListener(ChangesetReconciledListener listener) {
        this.listeners.removeListener(listener, CHANGESET_RECONCILED);
    }

    public void addWorkspaceCacheFileReloadedListener(WorkspaceCacheFileReloadedListener listener) {
        this.listeners.addListener(listener, WORKSPACE_CACHE_FILE_RELOADED);
    }

    public void removeWorkspaceCacheFileReloadedListener(WorkspaceCacheFileReloadedListener listener) {
        this.listeners.removeListener(listener, WORKSPACE_CACHE_FILE_RELOADED);
    }

    public void addLocalWorkspaceScanListener(LocalWorkspaceScanListener listener) {
        this.listeners.addListener(listener, LOCAL_WORKSPACE_SCAN);
    }

    public void removeLocalWorkspaceScanListener(LocalWorkspaceScanListener listener) {
        this.listeners.removeListener(listener, LOCAL_WORKSPACE_SCAN);
    }

    public void clear() {
        this.listeners.clear();
    }
}

