/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.specs;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpecParseException;
import com.microsoft.tfs.core.clients.versioncontrol.specs.VersionedFileSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import ms.tfs.versioncontrol.clientservices._03._ItemSpec;

public class ItemSpec
extends WebServiceObjectWrapper {
    public ItemSpec() {
        super(new _ItemSpec());
    }

    public ItemSpec(_ItemSpec spec) {
        super(spec);
    }

    public ItemSpec(String item, RecursionType recurse, int did) {
        super(new _ItemSpec(ItemPath.smartNativeToTFS(item), recurse == null ? null : recurse.getWebServiceObject(), did));
    }

    public ItemSpec(String item, RecursionType recurse) {
        this(item, recurse, 0);
    }

    public ItemSpec(PendingChange pendingChange) {
        this(pendingChange.getServerItem(), RecursionType.NONE, pendingChange.getDeletionID());
    }

    public _ItemSpec getWebServiceObject() {
        return (_ItemSpec)this.webServiceObject;
    }

    public static ItemSpec[] fromStrings(String[] localOrServerItems, RecursionType recursion) {
        Check.notNull(localOrServerItems, "localOrServerItems");
        Check.notNull(recursion, "recursion");
        ItemSpec[] ret = new ItemSpec[localOrServerItems.length];
        for (int i = 0; i < localOrServerItems.length; ++i) {
            VersionedFileSpec vfs = null;
            vfs = VersionedFileSpec.parse(localOrServerItems[i], "bogus", false);
            if (vfs == null) {
                throw new ItemSpecParseException(MessageFormat.format(Messages.getString("ItemSpec.ErrorParsingStringAsItemSpecFormat"), localOrServerItems[i]));
            }
            if (vfs.getVersions() != null && vfs.getVersions().length > 0) {
                throw new ItemSpecParseException(Messages.getString("ItemSpec.VersionsMayNotBeSpecifiedInSimpleItemSpecs"));
            }
            int did = vfs.getDeletionVersionSpec() != null ? vfs.getDeletionVersionSpec().getDeletionID() : 0;
            ret[i] = new ItemSpec(vfs.getItem(), recursion, did);
        }
        return ret;
    }

    public int getDeletionID() {
        return this.getWebServiceObject().getDid();
    }

    public String getItem() {
        return ItemPath.smartTFSToNative(this.getWebServiceObject().getItem());
    }

    public RecursionType getRecursionType() {
        return RecursionType.fromWebServiceObject(this.getWebServiceObject().getRecurse());
    }

    public void setDeletionID(int did) {
        this.getWebServiceObject().setDid(did);
    }

    public void setItem(String item) {
        this.getWebServiceObject().setItem(ItemPath.smartNativeToTFS(item));
    }

    public void setRecursionType(RecursionType recurse) {
        this.getWebServiceObject().setRecurse(recurse.getWebServiceObject());
    }

    @Override
    public String toString() {
        return MessageFormat.format("{0}:{1}", this.getWebServiceObject().getItem(), this.getWebServiceObject().getRecurse() != null ? this.getWebServiceObject().getRecurse().getName() : "null");
    }
}

