/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.workitem.ServerInfo;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.WorkItemServerVersion;
import com.microsoft.tfs.core.clients.workitem.internal.IWITContext;
import com.microsoft.tfs.core.clients.workitem.internal.QueryHierarchyProvider;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.DatastoreItemFieldUsagesCollection;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldModificationType;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadataChangeListener;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadataUpdateHandler;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.Metadata;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.ConstantMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.NodeMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryProviderImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rules.cache.IRuleCache;
import com.microsoft.tfs.core.clients.workitem.internal.rules.cache.RuleCache;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.core.internal.db.ConnectionConfiguration;
import com.microsoft.tfs.core.internal.db.ConnectionPool;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.text.MessageFormat;
import java.util.Set;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WITContext
implements IWITContext,
IMetadataChangeListener {
    private static final Log log = LogFactory.getLog(WITContext.class);
    private final WorkItemClient client;
    private final Metadata metadata;
    private ConstantMetadata currentUserConstant;
    private final String productValue;
    private final ConnectionPool connectionPool;
    private final ConnectionConfiguration connectionConfiguration;
    private String attachmentServerUrl;
    private NodeImpl rootNode;
    private FieldDefinitionCollectionImpl fieldDefinitions;
    private DatastoreItemFieldUsagesCollection workItemFieldUsages;
    private final StoredQueryProviderImpl queryProvider;
    private final QueryHierarchyProvider queryHierarchyProvider;
    private final RuleCache ruleCache;
    private final ServerInfo serverInfo;
    private final WorkItemServerVersion version;
    DatastoreItemFieldUsagesCollection workItemLinkFieldUsages;

    public WITContext(WorkItemClient client) {
        this.client = client;
        VersionControlClient vcClient = (VersionControlClient)client.getConnection().getClient(VersionControlClient.class);
        String guid = vcClient.getServerGUID().getGUIDString();
        this.connectionConfiguration = new ConnectionConfiguration(client.getConnection().getPersistenceStoreProvider().getCachePersistenceStore(), guid);
        this.connectionPool = new ConnectionPool(this.connectionConfiguration);
        this.metadata = new Metadata(this.connectionPool, client.getVersion(), client.getWebService2(), client.getWebService3(), client.getWebService5());
        TaskMonitorService.getTaskMonitor().setCurrentWorkDescription(Messages.getString("WITContext.TaskUpdatingClientMetadata"));
        this.metadata.update();
        this.metadata.addMetadataChangeListener(this);
        this.calculateCurrentUser();
        this.version = client.getVersion();
        this.productValue = this.isVersion2() ? client.getConnection().getWebServiceURI(client.getWebService2()).toString() : client.getConnection().getWebServiceURI(client.getWebService3()).toString();
        this.serverInfo = new ServerInfo(client.getVersion());
        this.queryProvider = new StoredQueryProviderImpl(this);
        this.queryHierarchyProvider = new QueryHierarchyProvider(this);
        this.ruleCache = new RuleCache(this);
    }

    @Override
    public synchronized void metadataChanged(Set<String> tableNames) {
        this.ruleCache.clearCache();
        this.rootNode = null;
        this.fieldDefinitions = null;
        this.workItemFieldUsages = null;
    }

    private void calculateCurrentUser() {
        String currentUserAndDomain = this.client.getConnection().getAuthorizedTFSUser().toString();
        this.currentUserConstant = this.getMetadata().getConstantsTable().getConstantByString(currentUserAndDomain);
        if (this.currentUserConstant == null) {
            String messageFormat = Messages.getString("WITContext.CurrentUserNotFoundFormat");
            String message = MessageFormat.format(messageFormat, currentUserAndDomain);
            throw new IllegalStateException(message);
        }
    }

    public synchronized FieldDefinitionCollectionImpl getFieldDefinitions() {
        if (this.fieldDefinitions == null) {
            this.fieldDefinitions = new FieldDefinitionCollectionImpl(true, this, null);
        }
        return this.fieldDefinitions;
    }

    public synchronized DatastoreItemFieldUsagesCollection getWorkItemFieldUsages() {
        if (this.workItemFieldUsages == null) {
            FieldDefinitionImpl workItemFieldDefinition = this.getFieldDefinitions().getFieldDefinitionInternal(-100);
            this.workItemFieldUsages = workItemFieldDefinition.getFieldUsageMetadata();
        }
        return this.workItemFieldUsages;
    }

    public synchronized DatastoreItemFieldUsagesCollection getWorkItemLinkFieldUsages() {
        if (this.workItemLinkFieldUsages == null) {
            FieldDefinitionImpl workItemFieldDefinition = this.getFieldDefinitions().getFieldDefinitionInternal(-101);
            this.workItemLinkFieldUsages = workItemFieldDefinition.getFieldUsageMetadata();
        }
        return this.workItemLinkFieldUsages;
    }

    public synchronized String getAttachmentServerURL() {
        if (this.attachmentServerUrl == null) {
            RegistrationClient registrationClient = this.getConnection().getRegistrationClient();
            this.attachmentServerUrl = registrationClient.getExtendedAttributeValue("WorkItemTracking", "AttachmentServerUrl");
            if (this.attachmentServerUrl == null) {
                log.error((Object)"attachment server url attribute was not located");
            } else if (!this.attachmentServerUrl.toLowerCase().startsWith("http")) {
                if (this.attachmentServerUrl.startsWith("/")) {
                    this.attachmentServerUrl = this.attachmentServerUrl.substring(1);
                }
                this.attachmentServerUrl = this.getConnection().getBaseURI().resolve(this.attachmentServerUrl).toString();
            }
        }
        return this.attachmentServerUrl;
    }

    public void shutdown() {
        this.connectionPool.shutdown();
    }

    @Override
    public String getCurrentUserDisplayName() {
        return this.currentUserConstant.getDisplayName();
    }

    public int getCurrentUserConstID() {
        return this.currentUserConstant.getConstID();
    }

    @Override
    public IMetadata getMetadata() {
        return this.metadata;
    }

    public IMetadataUpdateHandler getMetadataUpdateHandler() {
        return this.metadata;
    }

    public String getProductValue() {
        return this.productValue;
    }

    public WorkItemServerVersion getVersion() {
        return this.client.getVersion();
    }

    public _ClientService2Soap getProxy() {
        return this.client.getWebService2();
    }

    public _ClientService3Soap getProxy3() {
        return this.client.getWebService3();
    }

    public _ClientService5Soap getProxy5() {
        return this.client.getWebService5();
    }

    public TFSTeamProjectCollection getConnection() {
        return this.client.getConnection();
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public WorkItemClient getClient() {
        return this.client;
    }

    public synchronized NodeImpl getRootNode() {
        if (this.rootNode == null) {
            NodeMetadata rootNodeMetadata = this.metadata.getHierarchyTable().getRootNode();
            this.rootNode = new NodeImpl(rootNodeMetadata, null, this);
        }
        return this.rootNode;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public StoredQueryProviderImpl getQueryProvider() {
        return this.queryProvider;
    }

    public synchronized QueryHierarchyProvider getQueryHierarchyProvider() {
        return this.queryHierarchyProvider;
    }

    @Override
    public IRuleCache getRuleCache() {
        return this.ruleCache;
    }

    public boolean isVersion2() {
        return this.version.getValue() <= WorkItemServerVersion.V2.getValue();
    }

    public boolean isVersion3() {
        return this.version.getValue() == WorkItemServerVersion.V3.getValue();
    }

    public boolean isVersion5() {
        return this.version.getValue() >= WorkItemServerVersion.V5.getValue();
    }

    public boolean isVersion3OrHigher() {
        return this.version.getValue() >= WorkItemServerVersion.V3.getValue();
    }

    public void initNewWorkItem(WorkItemImpl workItem, WorkItemType type) {
        workItem.getFieldsInternal().ensureAllFieldsInWIPhysicalType();
        workItem.getFieldsInternal().getFieldInternal(25).setValue((Object)type.getName(), FieldModificationType.NEW);
        Integer projectId = new Integer(type.getProject().getID());
        workItem.getFieldsInternal().getFieldInternal(-2).setValue((Object)projectId, FieldModificationType.NEW);
        workItem.getFieldsInternal().getFieldInternal(-104).setValue((Object)projectId, FieldModificationType.NEW);
        workItem.getFieldsInternal().getFieldInternal(-3).setValue((Object)new Integer(0), FieldModificationType.NEW);
        workItem.getFieldsInternal().getFieldInternal(8).setValue((Object)new Integer(0), FieldModificationType.NEW);
    }
}

