/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.form;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.fields.Field;
import com.microsoft.tfs.core.clients.workitem.fields.FieldCollection;
import com.microsoft.tfs.core.clients.workitem.form.WIFormParam;
import com.microsoft.tfs.core.clients.workitem.form.WIFormParamTypeEnum;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormElementImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormParamTypeEnumFactory;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormParseHandler;
import org.xml.sax.Attributes;

public class WIFormParamImpl
extends WIFormElementImpl
implements WIFormParam {
    private String parameterIndex;
    private String parameterValue;
    private WIFormParamTypeEnum parameterType = WIFormParamTypeEnum.CURRENT;
    private String substitutionToken;

    @Override
    void startLoading(Attributes attributes) {
        this.parameterIndex = WIFormParseHandler.readStringValue(attributes, "Index");
        this.parameterValue = WIFormParseHandler.readStringValue(attributes, "Value");
        this.parameterType = WIFormParamTypeEnumFactory.fromType(attributes.getValue("Type"));
        this.setAttributes(attributes);
    }

    public String getIndex() {
        return this.parameterIndex;
    }

    public String getValue() {
        return this.parameterValue;
    }

    public WIFormParamTypeEnum getType() {
        return this.parameterType;
    }

    @Override
    public String getSubstitutionToken() {
        if (this.substitutionToken == null) {
            this.substitutionToken = "\\{" + this.parameterIndex + "\\}";
        }
        return this.substitutionToken;
    }

    @Override
    public String getSubstitutionValue(WorkItem workItem) {
        FieldCollection fields = workItem.getFields();
        Field field = fields.getField(this.parameterValue);
        if (field != null) {
            if (this.getType() == WIFormParamTypeEnum.ORIGINAL) {
                Object originalValue = field.getOriginalValue();
                if (originalValue != null) {
                    return originalValue.toString();
                }
            } else {
                Object currentValue = field.getValue();
                if (currentValue != null) {
                    return currentValue.toString();
                }
            }
        }
        return "";
    }
}

