/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.node;

import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.node.Node;
import com.microsoft.tfs.core.clients.workitem.node.NodeCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NodeCollectionImpl
implements NodeCollection {
    private final Set<Node> nodeSet = new HashSet<Node>();
    private List<Node> sortedNodes;
    private final Map<String, Node> nameToNodeMap = new HashMap<String, Node>();

    public NodeCollectionImpl(Collection<Node> allNodes) {
        for (Node node : allNodes) {
            this.nodeSet.add(node);
            this.nameToNodeMap.put(node.getName().toLowerCase(), node);
        }
    }

    @Override
    public boolean contains(Node node) {
        return this.nodeSet.contains(node);
    }

    @Override
    public Node get(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return this.nameToNodeMap.get(name.toLowerCase());
    }

    @Override
    public Node[] getNodes() {
        return this.getSortedNodes().toArray(new Node[0]);
    }

    @Override
    public int size() {
        return this.nodeSet.size();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getSortedNodes().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Node> getSortedNodes() {
        NodeCollectionImpl nodeCollectionImpl = this;
        synchronized (nodeCollectionImpl) {
            if (this.sortedNodes == null) {
                this.sortedNodes = new ArrayList<Node>();
                this.sortedNodes.addAll(this.nodeSet);
                Collections.sort(this.sortedNodes);
                this.sortedNodes = Collections.unmodifiableList(this.sortedNodes);
            }
        }
        return this.sortedNodes;
    }

    public NodeImpl getByNameInternal(String name) {
        return (NodeImpl)this.get(name);
    }
}

