/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.update;

import com.microsoft.tfs.core.clients.workitem.internal.InternalWorkItemUtils;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.exceptions.mappers.WorkItemExceptionMapper;
import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPFault;
import com.microsoft.tfs.core.ws.runtime.types.AnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.core.ws.runtime.types.StaxAnyContentType;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ms.tfs.workitemtracking.clientservices._03._ClientService2Soap_UpdateResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService3Soap_UpdateResponse;
import ms.tfs.workitemtracking.clientservices._03._ClientService5Soap_UpdateResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseUpdatePackage {
    private final WITContext context;
    private final Element root;

    public BaseUpdatePackage(WITContext context) {
        this.context = context;
        Document document = DOMCreateUtils.newDocument("Package");
        this.root = document.getDocumentElement();
        this.root.setAttribute("Product", context.getProductValue());
    }

    protected WITContext getContext() {
        return this.context;
    }

    protected Element getRoot() {
        return this.root;
    }

    public void update() {
        AnyContentType result;
        String dbStamp;
        AnyContentType metadata;
        try {
            if (this.context.isVersion2()) {
                _ClientService2Soap_UpdateResponse response = this.context.getProxy().update(this.getUpdatePackage(), this.context.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
                metadata = response.getMetadata();
                dbStamp = response.getDbStamp();
                result = response.getResult();
            } else if (this.context.isVersion3()) {
                _ClientService3Soap_UpdateResponse response = this.context.getProxy3().update(this.getUpdatePackage(), this.context.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
                metadata = response.getMetadata();
                dbStamp = response.getDbStamp();
                result = response.getResult();
            } else {
                _ClientService5Soap_UpdateResponse response = this.context.getProxy5().update(this.getUpdatePackage(), this.context.getMetadataUpdateHandler().getHaveEntries(), new DOMAnyContentType(), new StaxAnyContentType());
                metadata = response.getMetadata();
                dbStamp = response.getDbStamp();
                result = response.getResult();
            }
        }
        catch (SOAPFault soapFault) {
            throw WorkItemExceptionMapper.map(soapFault);
        }
        this.context.getMetadataUpdateHandler().updateMetadata(metadata, dbStamp);
        metadata.dispose();
        this.handleUpdateResponse((DOMAnyContentType)result);
    }

    protected abstract void handleUpdateResponse(DOMAnyContentType var1);

    protected DOMAnyContentType getUpdatePackage() {
        return new DOMAnyContentType(new Element[]{this.root});
    }

    public String getUpdateXML() {
        return DOMSerializeUtils.toString(this.root, 2);
    }

    protected Date parseDate(String input) {
        SimpleDateFormat dateFormat = InternalWorkItemUtils.newMetadataDateFormat();
        try {
            return dateFormat.parse(input);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

